<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php echo form_open_multipart('clients/open_ticket',array('id'=>'open-new-ticket-form')); ?>
<div class="row">
	<div class="col-md-12">

		<?php hooks()->do_action('before_client_open_ticket_form_start'); ?>

		<div class="panel_s">
			<div class="panel-heading text-uppercase open-ticket-subject text-center">
				<?php echo _l('clients_ticket_open_subject'); ?>
			</div>
			<div class="panel-body">
				<div class="row">
					<div class="col-md-8 col-md-offset-2">
						<p class="text-center alert alert-warning"><b>IMPORTANT : Toute demande de subvention doit répondre aux critères d'éligibilité de l'action correspondante : <a href="https://projets.ohelaterre.fr/knowledge-base/category/actions-eligibles" target="_blank" class="btn btn-default">en savoir +</a>.</b></p>  
						  <?php /*
						  if(total_rows(db_prefix().'projects',array('clientid'=>get_client_user_id())) > 0 && has_contact_permission('projects')){ ?>
						  <div class="form-group open-ticket-project-group">
							 <label for="project_id"><?php echo _l('project'); ?></label>
							 <select data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>" name="project_id" id="project_id" class="form-control selectpicker">
								<option value=""></option>
								<?php foreach($projects as $project){ ?>
								<option value="<?php echo $project['id']; ?>" <?php echo set_select('project_id',$project['id']); ?><?php if($this->input->get('project_id') == $project['id']){echo ' selected';} ?>><?php echo $project['name']; ?></option>
								<?php } ?>
							 </select>
						  </div>
						  <?php }
						   
						  */ 
						  
						  ?> 
					</div>
				</div>
						  
				<div class="row mtop30">
					<div class="col-md-6 ">
						   
						<?php // ACTIONS
						if(get_option('services') == 1 && count($services) > 0){ ?>
						<div class="form-group open-ticket-service-group">
							 <label for="service"><?php echo _l('clients_ticket_open_service'); ?></label> 
							 <select data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>" data-custom-field-required="1" name="service" id="service" class="form-control selectpicker">
								<option value=""></option>
								<?php foreach($services as $service){ ?>
									<?php if (($service['serviceid'] != "3") && ($service['serviceid'] != "2")){ ?>
									<?php } ?>
									<?php if ($service['servicestatus'] == "1") { ?>
										<option value="<?php echo $service['serviceid']; ?>" <?php echo set_select('service',$service['serviceid'],(count($services) == 1 ? true : false)); ?> title="<?php echo $service['name']; ?>"><?php echo $service['name']; ?></option> 
									<?php } else { ?>
										<?php /* <option value="" class="hide">ACTION CLÔTURÉE - <?php echo $service['name']; ?></option> */ ?>
									<?php } ?>
								<?php } ?>
							 </select>
						</div>
						<?php } ?>
							
						<div class="form-group open-ticket-department-group">
						   <label for="department"><?php echo _l('clients_ticket_open_departments'); ?></label>
						   <p class="small">Note : Vous devez être propriétaire de la parcelle ou avoir l’accord de son propriétaire.</p>
						   <select data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>" data-custom-field-required="1" name="department" id="department" class="form-control selectpicker">
							  <option value=""></option>
							  <?php foreach($departments as $department){ ?>
							  <option value="<?php echo $department['departmentid']; ?>" <?php echo set_select('department',$department['departmentid'],(count($departments) == 1 ? true : false)); ?>>
								 <?php echo $department['name']; ?>
							  </option>
							  <?php } ?>
						   </select>
						   <?php echo form_error('department'); ?>
						</div>
			
						<div class="form-group open-ticket-priority-group">
						   <label for="priority"><?php echo _l('clients_ticket_open_priority'); ?></label>
						   <select data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>" data-custom-field-required="1" name="priority" id="priority" class="form-control selectpicker">
							  <option value=""></option>
							  <?php foreach($priorities as $priority){ ?>
							  <option value="<?php echo $priority['priorityid']; ?>" <?php echo set_select('priority', $priority['priorityid'], hooks()->apply_filters('new_ticket_priority_selected', 2) == $priority['priorityid']); ?>>
									<?php echo ticket_priority_translate($priority['priorityid']); ?>
								 </option>
							  <?php } ?>
						   </select>
						   <?php echo form_error('priority'); ?>
						</div>
						 
					</div>  
		  
					<div class="col-md-6"> 
						<?php echo render_custom_fields( 'tickets','',array('id'=>24,'show_on_client_portal'=>1),array('items_applied'=>1)); ?>
						<div class="form-group open-ticket-message-group">
							<label for=""><?php echo _l('clients_ticket_open_body'); ?></label>
							<textarea name="message" id="message" class="form-control" rows="12"><?php echo set_value('message'); ?></textarea>
						</div>
					</div>  
		 
		 
					<div class="col-md-6 col-md-offset-3">
						<?php echo render_custom_fields( 'tickets','',array('id'=>10,'show_on_client_portal'=>1),array('items_applied'=>1)); ?>
					</div>
					
					<div class="col-md-6 col-md-offset-3"> 
						<?php echo render_custom_fields( 'tickets','',array('id'=>11,'show_on_client_portal'=>1),array('items_applied'=>1)); ?>
					</div>
					
					<div class="col-md-6 col-md-offset-3">
						<?php echo render_custom_fields( 'tickets','',array('id'=>12,'show_on_client_portal'=>1),array('items_applied'=>1)); ?>
					</div>
						 
				</div>
				
				<div class="col-md-6 hide">
					<div class="attachments_area open-ticket-attachments-area">
						<div class="row attachments">
							<div class="attachment">
								<div class="form-group">
									<label for="attachment" class="control-label"><?php echo _l('clients_ticket_attachments'); ?></label>
									<div class="input-group">
										<input type="file" extension="<?php echo str_replace(['.', ' '], '', get_option('ticket_attachments_file_extensions')); ?>" filesize="<?php echo file_upload_max_size(); ?>" class="form-control" name="attachments[0]" accept="<?php echo get_ticket_form_accepted_mimes(); ?>">
										<span class="input-group-btn">
											<button class="btn btn-success add_more_attachments p8-half" data-max="<?php echo get_option('maximum_allowed_ticket_attachments'); ?>" type="button"><i class="fa fa-plus"></i></button>
										</span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
		
				<div class="form-group open-ticket-subject-group">  
					<div id="infosDossier" class="hide">
						<span id="surfaceProjet"><?php echo date('Y-m-d'); ?></span>_<span id="actionProjet"><?php echo get_client_user_id(); ?></span>
					</div>
					<input type="hidden" class="form-control" name="subject" id="subject" value="">
					<?php echo form_error('subject'); ?>
				</div>
	  
				<div class="custom-fields hide">
					<?php /* echo render_custom_fields('tickets','',array('show_on_client_portal'=>1)); */ ?>
				</div>
					
			</div>
		</div>
		<div class="col-md-12 text-center mtop20">
			<button type="submit" class="btn btn-success btn-large" data-form="#open-new-ticket-form" autocomplete="off" data-loading-text="<?php echo _l('wait_text'); ?>">Enregistrer et transmettre ma demande de subvention</button>
		</div>
	</div>
</div>  
<?php echo form_close(); ?>
<script>    
$('body').on('change', '#service' , function() {
	if ($(this).val() != '') {
		actionProjet 	= $(this).find('option:selected').text();
		surfaceProjet 	= $('[data-fieldid="24"]').val();
		$('#actionProjet').text(actionProjet); 
		infosProjet 	= $('#surfaceProjet').text()+'_'+$('#actionProjet').text();
		$('#subject').val(infosProjet);   
		
		if (actionProjet.match("^Plantations : arbres fruitiers à coques")) {
			
			$('label[for="custom_fields[tickets][24]"]').html('Superficie : entre 1 et 10 hectares');
			$('[data-fieldid="24"]').val("1");
			$('[data-fieldid="24"]').attr({
			   "step" : 0.10, 
			   "min" : 1,
			   "max" : 10
			});
			
		} else if (actionProjet.match("^Plantations : haies")) {
			
			$('label[for="custom_fields[tickets][24]"]').html('Mètres linéaires : entre 300 et 1000');
			$('[data-fieldid="24"]').val("300");
			$('[data-fieldid="24"]').attr({
			   "step" : 1, 
			   "min" : 300,
			   "max" : 1000
			});
			
		} else if (actionProjet.match("^Bordures végétalisées fixes")) {
			
			$('label[for="custom_fields[tickets][24]"]').html('Superficie : entre 0.5 et 5 hectares');
			$('[data-fieldid="24"]').val("0.5");
			$('[data-fieldid="24"]').attr({
			   "step" : 0.5, 
			   "min" : 0.5,
			   "max" : 5
			});
			
		} else if (actionProjet.match("^Sursemis de trèfles sur prairies")) {
			
			$('label[for="custom_fields[tickets][24]"]').html('Superficie : entre 5 et 50 hectares');
			$('[data-fieldid="24"]').val("5");
			$('[data-fieldid="24"]').attr({
			   "step" : 0.5, 
			   "min" : 5,
			   "max" : 50
			});
			
		} else if (actionProjet.match("^Sursemis de trèfles dans les céréales")) {
			
			$('label[for="custom_fields[tickets][24]"]').html('Superficie : entre 5 et 50 hectares');
			$('[data-fieldid="24"]').val("5");
			$('[data-fieldid="24"]').attr({
			   "step" : 0.5, 
			   "min" : 5,
			   "max" : 50
			});
			
		} else if (actionProjet.match("^Semis à la volée des couverts mellifères")) {
			
			$('label[for="custom_fields[tickets][24]"]').html('Superficie : entre 5 et 50 hectares');
			$('[data-fieldid="24"]').val("5");
			$('[data-fieldid="24"]').attr({
			   "step" : 0.5, 
			   "min" : 5,
			   "max" : 50
			});
			
		} else if (actionProjet.match("^Semis de couverts mellifères dans les céréales")) {
			
			$('label[for="custom_fields[tickets][24]"]').html('Superficie : entre 5 et 50 hectares');
			$('[data-fieldid="24"]').val("5");
			$('[data-fieldid="24"]').attr({
			   "step" : 0.5, 
			   "min" : 5,
			   "max" : 50
			});
			
		} else if (actionProjet.match("^Corridors écologiques dans les luzernes semences et passages d’irrigation")) {
			
			$('label[for="custom_fields[tickets][24]"]').html('Superficie : entre 5 et 50 hectares');
			$('[data-fieldid="24"]').val("5");
			$('[data-fieldid="24"]').attr({
			   "step" : 0.5, 
			   "min" : 5,
			   "max" : 50
			});
			
		} else {
			$('label[for="custom_fields[tickets][24]"]').html('Vous devez choisir un type d\'action');
			$('[data-fieldid="24"]').val("0");
			$('[data-fieldid="24"]').attr({
			   "step" : 1, 
			   "min" : 0,
			   "max" : 0
			});
		}
		$('[data-fieldid="24"]').trigger('change');
		//console.log("change.....");
	}
});

$('body').on('change', '[data-fieldid="24"]' , function() {
	if ($(this).val() != '') {
		surfaceProjet = $(this).val();
		actionProjet = $('#actionProjet').find('option:selected').text();
		$('#surfaceProjet').text(surfaceProjet); 
		infosProjet 	= $('#surfaceProjet').text()+'_'+$('#actionProjet').text();
		$('#subject').val(infosProjet); 
		//console.log(infosProjet);
	}
});
</script>