<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
 
   <div class="row mtop40">
   
			  
		<div class="col-sm-6 col-sm-offset-1">
		   <div class="panel_s">
			  <div class="panel-body">
			  <h1 class="text-uppercase mbot20 login-heading">
				 <?php echo _l(get_option('allow_registration') == 1 ? 'clients_login_heading_register' : 'clients_login_heading_no_register'); ?>
			  </h1>
			  
			  <hr />

				<p class=" mtop15">L'<strong>Espace Projets Ohé la Terre</strong> permet d'accéder aux formulaires de demandes de subvention, au suivi des dossiers et à bien d'autres choses ! L'inscription est gratuite et ouverte aux <strong>agriculteurs du territoire Pays de la Loire / Nord Nouvelle Aquitaine</strong>. Si c'est votre première visite sur le site, utilisez le bouton <strong><a href="/authentication/register" title="S'enregistrer sur Ohé la Terre">JE SOUHAITE M'INSCRIRE</a></strong> et laissez-vous guider !</p>

				<p class=" mtop15">Ohé la Terre subventionne des <a href="https://www.ohelaterre.fr/nos-actions/" title="Les Actions Ohé la Terre en faveur de la biodiversité"><strong>actions en faveur de la biodiversité</strong></a>, grâce aux financement de nombreux mécènes : couverts végétaux, sursemis de trèfles dans les prairies, plantations de haies, d'arbres fruitiers etc. Pour toute question n'hésitez pas à <strong><a href="https://www.ohelaterre.fr/contact/" title="Contacter Ohé la Terre">nous contacter</a></strong> !</p> 
				
			  </div>
			</div>
		
			<div class="text-muted small mbottom40">À des fins de sécurité et d’audit, un enregistrement de toutes vos actions et modifications de connexion dans le tableau de bord Ohé la Terre sera enregistré dans un journal d’activité, pour une durée maximale de 6 mois. Le journal d’audit comprend également l’adresse IP à partir de laquelle vous avez accédé à ce site.</div>
		</div>
	   
   
	<div class="col-sm-4">
		  <?php echo form_open($this->uri->uri_string(), array('class' => 'login-form')); ?>
		  <?php hooks()->do_action('clients_login_form_start'); ?>
		  <div class="panel_s">
			 <div class="panel-body">
				<?php if (!is_language_disabled()) { ?>
				   <div class="form-group select-placeholder">
					  <label for="language" class="control-label"><?php echo _l('language'); ?>
					  </label>
					  <select name="language" id="language" class="form-control selectpicker" onchange="change_contact_language(this)" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>" data-live-search="true">
						 <?php $selected = (get_contact_language() != '' ) ? get_contact_language() : get_option('active_language'); ?>
						 <?php foreach ($this->app->get_available_languages() as $availableLanguage) {
						 ?>
							<option value="<?php echo $availableLanguage; ?>" <?php echo ($availableLanguage == $selected) ? 'selected' : '' ?>>
							   <?php echo ucfirst($availableLanguage); ?>
							</option>
						 <?php } ?>
					  </select>
				   </div>
				<?php } ?>
				<div class="form-group">
				   <label for="email"><?php echo _l('clients_login_email'); ?></label>
				   <input type="text" autofocus="true" class="form-control" name="email" id="email">
				   <?php echo form_error('email'); ?>
				</div>
				<div class="form-group">
				   <label for="password"><?php echo _l('clients_login_password'); ?></label>
				   <input type="password" class="form-control" name="password" id="password">
				   <?php echo form_error('password'); ?>
				</div>
				<?php if (show_recaptcha_in_customers_area()) { ?>
				   <div class="g-recaptcha mbot15" data-sitekey="<?php echo get_option('recaptcha_site_key'); ?>"></div>
				   <?php echo form_error('g-recaptcha-response'); ?>
				<?php } ?>
				<div class="text-center checkbox checkbox-inline">
				   <input type="checkbox" name="remember" id="remember">
				   <label for="remember" class="bold">
					  <?php echo _l('clients_login_remember'); ?>
				   </label>
				</div>

				<div class="form-group text-center">
				   <button type="submit" class="btn btn-info btn-block"><?php echo _l('clients_login_login_string'); ?></button>
				<a class="bold" href="<?php echo site_url('authentication/forgot_password'); ?>"><?php echo _l('customer_forgot_password'); ?></a>
				   <?php if (get_option('allow_registration') == 1) { ?>
				   <p class="text-center"><hr /></p>
					  <a href="<?php echo site_url('authentication/register'); ?>" class="btn btn-success btn-block"><?php echo _l('clients_register_string'); ?>
					  </a>
				   <?php } ?>
				<?php hooks()->do_action('clients_login_form_end'); ?>
				<?php echo form_close(); ?>
			 </div>
			 </div>
		  </div>
	   </div>
	   
   </div> 
