<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<table class="table dt-table table-tickets" data-order-col="<?php echo (get_option('services') == 1 ? 0 : 1); ?>" data-order-type="desc">
	<thead>
		<th class="th-proposal-number">ID</th>
		<th class="th-ticket-last-reply"><?php echo _l('clients_tickets_dt_last_reply'); ?></th> 
		<th class="th-ticket-status"><?php echo _l('clients_tickets_dt_status'); ?> de la demande</th>
		<th class="th-ticket-number">Action concernée</th>
	</thead>
	<tbody>
		<?php foreach($tickets as $ticket){ ?>
			<tr class="<?php if($ticket['clientread'] == 0){echo 'active bold';} ?>">
				<td data-order="<?php echo $ticket['ticketid']; ?>"> 
					<a href="<?php echo site_url('clients/ticket/'.$ticket['ticketid']); ?>" class="btn btn_layout_light small"><?php echo '#'; ?><?php echo $ticket['ticketid']; ?></a>
				</td>
				<td data-order="<?php echo $ticket['lastreply']; ?>">
					<?php if ($ticket['lastreply'] == NULL) {
						echo _l('client_no_reply');
					} else {
						echo _dt($ticket['lastreply']);
					}
					if ($ticket['clientread'] == 0) { 
						echo '<br /><span class="badge badge-danger"><i class="fa fa-exclamation" aria-hidden="true"></i> À consulter</span>';
					}
					?>
				</td>
				<td data-order="<?php echo $ticket['ticketstatusid']; ?>">
					<span class="small text-center white s-status bold" style="background:<?php echo $ticket['statuscolor']; ?>"><?php echo ticket_status_translate($ticket['ticketstatusid']); ?></span>
				</td>
				<td data-order="<?php echo $ticket['service_name']; ?>">
					<a href="<?php echo site_url('clients/ticket/'.$ticket['ticketid']); ?>" class="btn btn_layout_light small"><?php echo $ticket['service_name']; ?></a>
				</td> 
			</tr>
		<?php } ?>
	</tbody>
</table>
 
<?php /*

// label inline-block s-status 
	<th class="th-ticket-subject hide"><?php echo _l('clients_tickets_dt_subject'); ?></th> 
	<th class="th-ticket-project hide"><?php echo _l('project'); ?></th>
	<?php if(get_option('services') == 1){ ?>
	<th class="th-ticket-service hide"><?php echo _l('clients_tickets_dt_service'); ?></th>
	<?php } ?>
	<th class="th-ticket-priority hide"><?php echo _l('priority'); ?></th>
	if($show_submitter_on_table) { ?>
		<th class="th-ticket-submitter"><?php echo _l('ticket_dt_submitter'); ?></th>
		<?php } ?> 
		<th class="th-ticket-department"><?php echo _l('clients_tickets_dt_department'); ?></th> 
	<?php $custom_fields = get_custom_fields('tickets',array('show_on_client_portal'=>1));
	foreach($custom_fields as $field){ ?>
		<?php if ($field['name'] == 'Action concernée par la demande de subvention') { ?>
			<th><?php echo $field['name']; ?></th>
		<?php } ?>
	<?php } ?>
	
	
	<?php foreach($custom_fields as $field) { 
			if ($field['name'] == 'Action concernée par la demande de subvention') {
				echo '<td>'. get_custom_field_value($ticket['ticketid'],$field['id'],'tickets') .'</td>';
			} 
		} ?>
	if(get_option('services') == 1){ ?>
	<td class="hide">
	<?php echo $ticket['service_name']; ?>
	</td>
	<?php } ?>
	<?php  if($show_submitter_on_table) { ?>
	<td>
	<?php echo $ticket['user_firstname'] . ' ' . $ticket['user_lastname'];  ?>
	</td>
	<?php }  ?>
	<td class="hide">
	<a href="<?php echo site_url('clients/ticket/'.$ticket['ticketid']); ?>" class="btn btn-primary small">
	#<?php echo $ticket['ticketid']; ?>_<?php echo $ticket['subject']; ?>
	</a>
	</td>
	<td>
	<?php echo $ticket['department_name']; ?>
	</td>
	<td class="hide">
	<?php
	if($ticket['project_id'] != 0){
	echo '<a href="'.site_url('clients/project/'.$ticket['project_id']).'">'.get_project_name_by_id($ticket['project_id']).'</a>';
	}
	?>
	</td>
	<td class="hide">
	<?php
	echo ticket_priority_translate($ticket['priority']);
	?>
	</td>
<?php */ ?>