<?php defined('BASEPATH') or exit('No direct script access allowed'); 
 
function isDomainAvailible($domain){
	if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
		$ip = $_SERVER['HTTP_CLIENT_IP'];
	} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$ip = $_SERVER['REMOTE_ADDR'];
	}
	
	// Check, if a valid url is provided
	if(!filter_var($domain, FILTER_VALIDATE_URL)){
		return false;
	}

	// Initialize curl
	$curlInit = curl_init($domain);
	curl_setopt($curlInit,CURLOPT_CONNECTTIMEOUT,20);
	curl_setopt($curlInit,CURLOPT_HEADER,true);
	curl_setopt($curlInit,CURLOPT_NOBODY,true);
	//curl_setopt($curlInit, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($curlInit,CURLOPT_RETURNTRANSFER,true);
	curl_setopt($curlInit, CURLOPT_PROTOCOLS, CURLPROTO_HTTPS);
	curl_setopt($curlInit, CURLOPT_PROTOCOLS, CURLPROTO_HTTP);
	//curl_setopt ($curlInit, CURLOPT_CAINFO, dirname(__FILE__)."/cron.php");
	// Get answer
	$response = curl_exec($curlInit); 
	curl_close($curlInit); 
	if ($response){ 
		$statut = "OK";
	} else { 
		$statut = "KO";
	}
	$log  = "IP : ".$ip.' - '.date("Y/m/d g:i a")." - STATUT : ".$statut.PHP_EOL.
			"-------------------------"
			.PHP_EOL;
	file_put_contents('cron.php', $log, FILE_APPEND);
	return $log;
}

if (is_client_logged_in()) {
	//$domain = 'https://projets.ohelaterre.fr/cron/index';
	//$avi = isDomainAvailible($domain); 
	//echo $avi;
}
?>
<!DOCTYPE html>
<html lang="<?php echo $locale; ?>">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<title><?php if (isset($title)){ echo $title; } ?></title>
	<?php echo compile_theme_css(); ?>
	<script src="<?php echo base_url('assets/plugins/jquery/jquery.min.js'); ?>"></script>
	<?php app_customers_head(); ?>
</head>
<body class="customers <?php echo strtolower($this->agent->browser()); ?><?php if(is_mobile()){echo ' mobile';}?><?php if(isset($bodyclass)){echo ' ' . $bodyclass; } ?>" <?php if($isRTL == 'true'){ echo 'dir="rtl"';} ?>>
	<?php hooks()->do_action('customers_after_body_start'); ?>
