<?php

defined('BASEPATH') or exit('No direct script access allowed');

$custom_fields = get_table_custom_fields('proposal');
$custom_fields_suite = get_custom_fields('customers');
$this->ci->db->query("SET sql_mode = ''");

$baseCurrency = get_base_currency();
$project_id   = $this->ci->input->post('project_id');
$whereDossier = ""; 

$actions      = $this->ci->proposals_model->get_actions();
$actionsArray = [];
foreach ($actions as $action) {
    if ($this->ci->input->post('action_' . $action['id'])) { 
        array_push($actionsArray, $action['id']); 
    }
}
if (count($actionsArray) > 0) {
     $whereDossier = 'AND ' . db_prefix() . 'items.id IN (' . implode(', ', $actionsArray) . ') ';
     $whereCompany = 'AND ' . db_prefix() . 'clients.userid IN (' . implode(', ', $actionsArray) . ') ';
}
 
$aColumns = [
    db_prefix() . 'proposals.id', 
    db_prefix() . 'proposals.hash',
    'subject',
    'proposal_to', 
    db_prefix() . 'clients.company', 
    db_prefix() . 'items.description', 
    db_prefix() . 'itemable.description', 
    db_prefix() . 'itemable.qty', 
    'total',
    'date',
    'open_till',
    db_prefix() . 'proposals.datecreated',
    db_prefix() . 'proposals.status as proposal_status',	
 
	'(SELECT DISTINCT GROUP_CONCAT("",' . db_prefix() . 'itemable.description," (", ' . db_prefix() . 'itemable.qty, ")" SEPARATOR "'.PHP_EOL.'") 
	FROM  ' . db_prefix() . 'itemable   
	LEFT JOIN ' . db_prefix() . 'items ON ' . db_prefix() . 'itemable.description = ' . db_prefix() . 'items.description
	WHERE ' . db_prefix() . 'itemable.rel_id = ' . db_prefix() . 'proposals.id  and rel_type="proposal"
	'.$whereDossier.' 
	 ORDER by item_order DESC) AS dossier',
	 

	'(SELECT GROUP_CONCAT(name SEPARATOR ",") 
	FROM ' . db_prefix() . 'taggables 
	JOIN ' . db_prefix() . 'tags ON ' . db_prefix() . 'taggables.tag_id = ' . db_prefix() . 'tags.id
	WHERE ' . db_prefix() . 'proposals.rel_id = ' . db_prefix() . 'proposals.id and rel_type="proposal" ORDER by tag_order ASC) as tags',
	 
];

  
$join = [
    'LEFT JOIN ' . db_prefix() . 'clients ON ' . db_prefix() . 'clients.userid = ' . db_prefix() . 'proposals.rel_id',
    'LEFT JOIN ' . db_prefix() . 'itemable ON ' . db_prefix() . 'itemable.rel_id = ' . db_prefix() . 'proposals.id',
    'LEFT JOIN ' . db_prefix() . 'items ON ' . db_prefix() . 'itemable.description = ' . db_prefix() . 'items.description',
    'LEFT JOIN ' . db_prefix() . 'projects ON ' . db_prefix() . 'projects.id = ' . db_prefix() . 'proposals.project_id', 
];
  
foreach ($custom_fields as $key => $field) {
    $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
    array_push($customFieldsColumns, $selectAs);
    array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
    array_push($join, 'LEFT JOIN ' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' ON ' . db_prefix() . 'proposals.id = ctable_' . $key . '.relid AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '" AND ctable_' . $key . '.fieldid=' . $field['id']);
}
 

foreach ($custom_fields_suite as $key => $field) { 
	if (($field['id'] == "2") || ($field['id'] == "3") || ($field['id'] == "25")) { 
		$selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
		array_push($customFieldsColumns, $selectAs);
		array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
		array_push($join, ' 
		LEFT JOIN 
		' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' 
		ON ' . db_prefix() . 'clients.userid = ctable_' . $key . '.relid  
		AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '"  
		AND ctable_' . $key . '.fieldid=' . $field['id']);
	} 
}
$where  = [];
$filter = [];
 
if (!$project_id) {
    $aColumns[] = 'project_id';
}
  
$actions      = $this->ci->proposals_model->get_actions();
$actionsArray = [];

foreach ($actions as $action) {
    if ($this->ci->input->post('action_' . $action['id'])) { 
        array_push($actionsArray, $action['id']); 
    }
}
if (count($actionsArray) > 0) {
    // BUG HUGO A FINIR
	// array_push($filter, 'AND ' . db_prefix() . 'items.id IN (' . implode(', ', $actionsArray) . ') ');
}
 
if ($this->ci->input->post('leads_related')) {
    array_push($filter, 'OR rel_type="lead"');
}
if ($this->ci->input->post('customers_related')) {
    array_push($filter, 'OR rel_type="customer"');
}
if ($this->ci->input->post('expired')) {
    array_push($filter, 'OR open_till IS NOT NULL AND open_till <"' . date('Y-m-d') . '" AND ' . db_prefix() . 'proposals.status NOT IN(2,3)');
}
$statuses  = $this->ci->proposals_model->get_statuses();
$statusIds = [];
foreach ($statuses as $status) {
    if ($this->ci->input->post('proposals_' . $status)) {
        array_push($statusIds, $status);
    }
}
if (count($statusIds) > 0) {
    array_push($filter, 'AND' . db_prefix() . 'proposals.status IN (' . implode(', ', $statusIds) . ')');
}
$agents    = $this->ci->proposals_model->get_sale_agents();
$agentsIds = [];
foreach ($agents as $agent) {
    if ($this->ci->input->post('sale_agent_' . $agent['sale_agent'])) {
        array_push($agentsIds, $agent['sale_agent']);
    }
}
if (count($agentsIds) > 0) {
    array_push($filter, 'AND assigned IN (' . implode(', ', $agentsIds) . ')');
}
$years      = $this->ci->proposals_model->get_proposals_years();
$yearsArray = [];
foreach ($years as $year) {
    if ($this->ci->input->post('year_' . $year['year'])) {
        array_push($yearsArray, $year['year']);
    }
}
if (count($yearsArray) > 0) {
    array_push($filter, 'AND YEAR(date) IN (' . implode(', ', $yearsArray) . ')');
} 

  //array_push($filter, 'AND YEAR(date) IN (' . implode(', ', $yearsArray) . ')');
  
if (count($filter) > 0) {
    array_push($where, 'AND (' . prepare_dt_filter($filter) . ') GROUP BY tblproposals.id ');
}
if (!has_permission('proposals', '', 'view')) {
    array_push($where, 'AND ' . get_proposals_sql_where_staff(get_staff_user_id()));
}


if ($project_id) { 
    $where[] = 'AND project_id=' . $this->ci->db->escape_str($project_id);
}
// $where[] = ' AND dossier NOT LIKE ("")  ';
// $where[] = ' AND ' . db_prefix() . 'itemable.rel_type = "proposal" ';
// $where[] = ' AND ' . db_prefix() . 'itemable.rel_id = ' . db_prefix() . 'proposals.id';


$sIndexColumn = 'id';
$sTable       = db_prefix() . 'proposals';

$aColumns = hooks()->apply_filters('proposals_table_sql_columns', $aColumns);

 
// Fix for big queries. Some hosting have max_join_limit
if (count($custom_fields) > 4) {
    @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
}
$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    'company',
    'currency',
    'invoice_id', 
    db_prefix() . 'proposals.hash as hash',
    db_prefix() . 'proposals.rel_id',
    db_prefix() . 'proposals.rel_type',
    db_prefix() . 'projects.name as project_name',
	'ctable_1.value as cvalue_1', 
	'ctable_2.value as cvalue_2', 
	'ctable_5.value as cvalue_5' 
]);

$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
	
		$row = [];
		$numberOutput = '<a href="' . admin_url('proposals/list_proposals/' . $aRow[db_prefix() . 'proposals.id']) . '"' . ($project_id ? 'target="_blank"' : 'onclick="init_proposal(' . $aRow[db_prefix() . 'proposals.id'] . '); return false;"') . ' class="btn  btn_layout_light small" >#' . $aRow[db_prefix() . 'proposals.id'] . '</a>';
		
		// Nom complet exemple "CONTRAT-0006" : format_proposal_number($aRow[db_prefix() . 'proposals.id'])
		$numberOutput .= '<div class="row-options">';
		$numberOutput .= '<a href="' . site_url('proposal/' . $aRow[db_prefix() . 'proposals.id'] . '/' . $aRow['hash']) . '" target="_blank">' . _l('view') . '</a>';
		if (has_permission('proposals', '', 'edit')) {
			$numberOutput .= ' | <a href="' . admin_url('proposals/proposal/' . $aRow[db_prefix() . 'proposals.id']) . '"' . ($project_id ? 'target="_blank"': '') . '>' . _l('edit') . '</a>';
		}
		$numberOutput .= '</div>';
		$row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow[db_prefix() . 'proposals.id'] . '"><label></label></div>';

		//$row[] = $aRow[db_prefix() . 'proposals.id'];
		//$row[] = _d($aRow['tblproposals.datecreated']);
		$row[] = $aRow['tblproposals.datecreated'];
		$row[] = $numberOutput;
		
		$row[] = format_proposal_status($aRow['proposal_status']);
	   // $row[] = '<a href="' . admin_url('proposals/list_proposals/' . $aRow[db_prefix() . 'proposals.id']) . '"' . ($project_id ? 'target="_blank"' : 'onclick="init_proposal(' . $aRow[db_prefix() . 'proposals.id'] . '); return false;"') . '>' . $aRow['subject'] . '</a>';
		if ($aRow['rel_type'] == 'lead') {
			$toOutput = '<a href="#" onclick="init_lead(' . $aRow['rel_id'] . ');return false;" target="_blank" data-toggle="tooltip" data-title="' . _l('lead') . '" class="btn  btn_layout_light small">' . $aRow['company'] . '</a>';
		} elseif ($aRow['rel_type'] == 'customer') {
			$toOutput = '<a href="' . admin_url('clients/client/' . $aRow['rel_id']) . '" target="_blank" data-toggle="tooltip" data-title="' . _l('client') . '" class="btn  btn_layout_light small">' . $aRow['company'] . '</a>';
		}
		if (strtoupper($aRow['company']) != strtoupper($aRow['proposal_to'])) {
			$name_parts = explode(" ", strtoupper($aRow['proposal_to'])); 
			$first_name = $name_parts[0]; 
			$last_name = $name_parts[1]; 
			if (strtoupper($aRow['company']) != ($last_name.' '.$first_name))  {
				$toOutput .= '<div class="text-left small">'.ucfirst(strtolower($first_name)).' '.$last_name.'</div>';
			}
		}
		
		$row[] = $toOutput;
		
		$amount = app_format_money($aRow['total'], ($aRow['currency'] != 0 ? get_currency($aRow['currency']) : $baseCurrency));
		if ($aRow['invoice_id']) {
			$amount .= '<br /> <span class="hide"> - </span><span class="text-success tw-text-sm">' . _l('estimate_invoiced') . '</span>';
		}
		$row[] = $amount;
		//$row[] = _d($aRow['open_till']);
		$row[] = $aRow['open_till'];
		if (!$project_id) {
			//$row[] = "";
		} else {
			$row[] = '<a href="' . admin_url('projects/view/' . $aRow['project_id']) . '" target="_blank">' . $aRow['project_name'] . '</a>';
		}
		
		// HUGO  
		$actions = '';
		 if ($aRow['dossier'] != "") { 
			$actions .= '<a href="https://projets.ohelaterre.fr/proposal/' . $aRow[db_prefix() . 'proposals.id'] . '/' . $aRow['hash'] . '" target="_blank">'.str_replace('.00','',$aRow['dossier']).'</a>';
		}
		//$actions .= '• '.$aRow['tblitemable.description'].' ('.$aRow['tblitemable.qty'].')';    
		
		$row[] = $actions; 
		/* 
		foreach ($customFieldsColumns as $action) {
			// ("• ",' . db_prefix() . 'itemable.description," (", ' . db_prefix() . 'itemable.qty, ")" SEPARATOR "'.PHP_EOL.'")
			$row[] = $aRow[$action]);
		} */
	   
		if ($aRow['cvalue_2'] != "") { 
			$NOBENEFICIAIRE = '<a href="/admin/clients/client/'.$aRow['rel_id'].'#custom_fields" target="_blank" class="" >'.$aRow['cvalue_2'].'</a>';
		} else {
			$NOBENEFICIAIRE = '<a href="/admin/clients/client/'.$aRow['rel_id'].'#custom_fields" target="_blank" class="text-danger" >Manquant</a>';
		}
		if ($aRow['cvalue_1'] != "") { 
			$SIRET = '<a href="/admin/clients/client/'.$aRow['rel_id'].'#custom_fields" target="_blank" class="" >'.$aRow['cvalue_1'].'</a>';
		} else {
			$SIRET = '<a href="/admin/clients/client/'.$aRow['rel_id'].'#custom_fields" target="_blank" class="text-danger" >Manquant</a>';
		}
		if ($aRow['cvalue_5'] != "") {
			$IBAN = '<a href="/admin/clients/client/'.$aRow['rel_id'].'#custom_fields" target="_blank" class="" >'.$aRow['cvalue_5'].'</a>';
		} else {
			$IBAN = '<a href="/admin/clients/client/'.$aRow['rel_id'].'#custom_fields" target="_blank" class="text-danger" >Manquant</a>';
		} 
		$row[] = ''.$NOBENEFICIAIRE.'';
		$row[] = ''.$SIRET.'';
		$row[] = ''.$IBAN.'';
	   
	   
		$row[] = render_tags($aRow['tags']); 
	   // $row[] = "...".$aRow['items'] ; /* ".."; */
	   
		//$row[] = _d($aRow['datecreated']); 
		// Custom fields add values
		foreach ($customFieldsColumns as $customFieldColumn) {
			//$row[] = (strpos($customFieldColumn, 'date_picker_') !== false ? _d($aRow[$customFieldColumn]) : $aRow[$customFieldColumn]);
			$row[] = (strpos($customFieldColumn, 'date_picker_') !== false ? $aRow[$customFieldColumn] : $aRow[$customFieldColumn]);
		}
		$row['DT_RowClass'] = 'has-row-options';
		$row = hooks()->apply_filters('proposals_table_row_data', $row, $aRow);
		$output['aaData'][] = $row; 
}