<?php

defined('BASEPATH') or exit('No direct script access allowed');
 
$custom_fields = get_table_custom_fields('expenses');
$custom_fields_suite = get_custom_fields('customers');
$this->ci->db->query("SET sql_mode = ''");

$aColumns = [
    '1', // bulk actions
    db_prefix() . 'expenses.id as id',
	db_prefix() . 'expenses.dateadded as dateadded',
    db_prefix() . 'expenses_categories.name as category_name',
    'amount',
    'expense_name', 
    'date',
    db_prefix() . 'projects.name as project_name',
    get_sql_select_client_company(),
    'invoiceid',
    'reference_no',
    'paymentmode',
];
$sIndexColumn = 'id';
$sTable       = db_prefix() . 'expenses';
$where  = [];
$filter = [];
$join = [
    'LEFT JOIN ' . db_prefix() . 'clients ON ' . db_prefix() . 'clients.userid = ' . db_prefix() . 'expenses.clientid', 
    'JOIN ' . db_prefix() . 'expenses_categories ON ' . db_prefix() . 'expenses_categories.id = ' . db_prefix() . 'expenses.category',
    'LEFT JOIN ' . db_prefix() . 'projects ON ' . db_prefix() . 'projects.id = ' . db_prefix() . 'expenses.project_id',
    'LEFT JOIN ' . db_prefix() . 'files ON ' . db_prefix() . 'files.rel_id = ' . db_prefix() . 'expenses.id AND rel_type="expense"',
    'LEFT JOIN ' . db_prefix() . 'currencies ON ' . db_prefix() . 'currencies.id = ' . db_prefix() . 'expenses.currency',
];

foreach ($custom_fields as $key => $field) {
    $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
    array_push($customFieldsColumns, $selectAs);
    array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
    array_push($join, 'LEFT JOIN ' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' ON ' . db_prefix() . 'expenses.id = ctable_' . $key . '.relid AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '" AND ctable_' . $key . '.fieldid=' . $field['id']);
}

foreach ($custom_fields_suite as $key => $field) { 
	if (($field['id'] == "2") || ($field['id'] == "3") || ($field['id'] == "25")) {
		$selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
		array_push($customFieldsColumns, $selectAs);
		array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
		array_push($join, ' 
		LEFT JOIN 
		' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' 
		ON ' . db_prefix() . 'clients.userid = ctable_' . $key . '.relid  
		AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '"  
		AND ctable_' . $key . '.fieldid=' . $field['id']);
	} 
}

include_once(APPPATH . 'views/admin/tables/includes/expenses_filter.php');

if ($clientid != '') {
    array_push($where, 'AND ' . db_prefix() . 'expenses.clientid=' . $this->ci->db->escape_str($clientid));
}

if (!has_permission('expenses', '', 'view')) {
    array_push($where, 'AND ' . db_prefix() . 'expenses.addedfrom=' . get_staff_user_id());
}


$aColumns = hooks()->apply_filters('expenses_table_sql_columns', $aColumns);

// Fix for big queries. Some hosting have max_join_limit
if (count($custom_fields) > 4) {
    @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
}

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    'billable', 
    db_prefix() . 'currencies.name as currency_name',
    db_prefix() . 'expenses.clientid',
    'tax',
    'tax2',
    'project_id',
    'recurring', 
	'ctable_1.value as cvalue_1', 
	'ctable_2.value as cvalue_2', 
	'ctable_5.value as cvalue_5' 
]);
$output  = $result['output'];
$rResult = $result['rResult'];

$this->ci->load->model('payment_modes_model');

foreach ($rResult as $aRow) {
    $row = [];

    $row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow['id'] . '"><label></label></div>';

    $row[] = $aRow['id'];
	//$row[] = _d($aRow['dateadded']); 
	$row[] = $aRow['dateadded']; 
	
    $clientOutput = '<a href="' . admin_url('clients/client/' . $aRow['clientid']) . '" target="_blank" class="btn  btn_layout_light small">' . $aRow['company'] . '</a>';
	/*
		if (strtoupper($aRow['company']) != strtoupper($aRow['proposal_to'])) {
			$name_parts = explode(" ", strtoupper($aRow['proposal_to'])); 
			$first_name = $name_parts[0]; 
			$last_name = $name_parts[1]; 
			if (strtoupper($aRow['company']) != ($last_name.' '.$first_name))  {
				$clientOutput .= '<div class="text-left small">'.ucfirst(strtolower($first_name)).' '.$last_name.'</div>';
			}
		}
	*/
	$row[] = $clientOutput;

    $categoryOutput = '';
    $statut = '';

    if (is_numeric($clientid)) {
        $categoryOutput = '<a href="' . admin_url('expenses/list_expenses/' . $aRow['id']) . '" class=" small">' . $aRow['category_name'] . '</a>';
    } else {
        $categoryOutput = '<a href="' . admin_url('expenses/list_expenses/' . $aRow['id']) . '" onclick="init_expense(' . $aRow['id'] . ');return false;" class="bold small">' . $aRow['category_name'] . '</a>';
    }

    if ($aRow['billable'] == 1) {
        if ($aRow['invoiceid'] == null) {
            $statut .= ' <p class="label label-danger  s-status invoice-status-1">' . _l('expense_list_unbilled') . '</p>';
        } else {
            if (total_rows(db_prefix() . 'invoices', [
                'id' => $aRow['invoiceid'],
                'status' => 2,
                ]) > 0) { 
                $statut .= '<a href="' . admin_url('invoices/list_invoices/' . $aRow['invoiceid']) . '" class="label label-success  s-status invoice-status-2"><strong>' . _l('expense_list_billed') . '</strong><br />' . format_invoice_number($aRow['invoiceid']) . '</a>';
            } else {
                $statut .= '<a href="' . admin_url('invoices/list_invoices/' . $aRow['invoiceid']) . '" class="label label-success  s-status invoice-status-2"><strong>' . _l('expense_list_invoice') . '</strong><br />' . format_invoice_number($aRow['invoiceid']) . '</a>';
            }
        }
    } else {
                $statut .= '<span class="label label-warning  s-status invoice-status-3">Non subventionnable</span>';
            }

    if ($aRow['recurring'] == 1) {
        $categoryOutput .= '<span class="label label-primary"> ' . _l('expense_recurring_indicator') . '</span>';
    }

    $categoryOutput .= '<div class="row-options">';


    $categoryOutput .= '<a href="' . admin_url('expenses/list_expenses/' . $aRow['id']) . '" onclick="init_expense(' . $aRow['id'] . ');return false;">' . _l('view') . '</a>';

    if (has_permission('expenses', '', 'edit')) {
        $categoryOutput .= ' | <a href="' . admin_url('expenses/expense/' . $aRow['id']) . '">' . _l('edit') . '</a>';
    }

    if (has_permission('expenses', '', 'delete')) {
        $categoryOutput .= ' | <a href="' . admin_url('expenses/delete/' . $aRow['id']) . '" class="text-danger _delete">' . _l('delete') . '</a>';
    }

    $categoryOutput .= '</div>';
    $row[] = $categoryOutput;
    $row[] = $statut;

    $total    = $aRow['amount'];
    $tmpTotal = $total;

    if ($aRow['tax'] != 0) {
        $tax = get_tax_by_id($aRow['tax']);
        $total += ($total / 100 * $tax->taxrate);
    }
    if ($aRow['tax2'] != 0) {
        $tax = get_tax_by_id($aRow['tax2']);
        $total += ($tmpTotal / 100 * $tax->taxrate);
    }

    $row[] = app_format_money($total, $aRow['currency_name']);

    $row[] = '<a href="' . admin_url('expenses/list_expenses/' . $aRow['id']) . '" onclick="init_expense(' . $aRow['id'] . ');return false;">' . $aRow['expense_name'] . '</a>';

    $outputReceipt = '';

    if (!empty($aRow['file_name'])) {
        $outputReceipt = '<a href="' . site_url('download/file/expense/' . $aRow['id']) . '" class="text-success bold">Enregistré</a><span class="hide"> ' . site_url('download/file/expense/' . $aRow['id']) . '</span>';
		 
    } else { 
        $outputReceipt = '<a href="' . admin_url('expenses/list_expenses/' . $aRow['id']) . '" onclick="init_expense(' . $aRow['id'] . ');return false;" class="bold small text-danger">Manquant</a>';
    }
	

   // $row[] = $outputReceipt;

    //$row[] = _d($aRow['date']);
    $row[] = $aRow['date'];

     

	if ($aRow['project_id']) {
       // $row[] = '<a href="' . admin_url('projects/view/' . $aRow['project_id']) . '" target="_blank" class="btn  btn_layout_light small">' . $aRow['project_name'] . '</a>';
    } else {
       // $row[] = '';
    } 
	
	
	if ($aRow['cvalue_2'] != "") { 
		$NOBENEFICIAIRE = '<a href="/admin/clients/client/'.$aRow['clientid'].'#custom_fields" target="_blank" class="" >'.$aRow['cvalue_2'].'</a>';
	} else {
		$NOBENEFICIAIRE = '<a href="/admin/clients/client/'.$aRow['clientid'].'#custom_fields" target="_blank" class="text-danger" >Manquant</a>';
	}
	if ($aRow['cvalue_1'] != "") { 
		$SIRET = '<a href="/admin/clients/client/'.$aRow['clientid'].'#custom_fields" target="_blank" class="" >'.$aRow['cvalue_1'].'</a>';
	} else {
		$SIRET = '<a href="/admin/clients/client/'.$aRow['clientid'].'#custom_fields" target="_blank" class="text-danger" >Manquant</a>';
	}
	if ($aRow['cvalue_5'] != "") {
		$IBAN = '<a href="/admin/clients/client/'.$aRow['clientid'].'#custom_fields" target="_blank" class="" >'.$aRow['cvalue_5'].'</a>';
	} else {
		$IBAN = '<a href="/admin/clients/client/'.$aRow['clientid'].'#custom_fields" target="_blank" class="text-danger" >Manquant</a>';
	} 
    $row[] = ''.$NOBENEFICIAIRE.'';
    $row[] = ''.$SIRET.'';
    $row[] = ''.$IBAN.''; 


    if ($aRow['invoiceid']) {
        $row[] = '<a href="' . admin_url('invoices/list_invoices/' . $aRow['invoiceid']) . '">' . format_invoice_number($aRow['invoiceid']) . '</a>';
    } else {
        $row[] = '';
    }

    $row[] = $aRow['reference_no'];

    $paymentModeOutput = '';
    if ($aRow['paymentmode'] != '0' && !empty($aRow['paymentmode'])) {
        $payment_mode = $this->ci->payment_modes_model->get($aRow['paymentmode'], [], false, true);
        if ($payment_mode) {
            $paymentModeOutput = $payment_mode->name;
        }
    }
    $row[] = $paymentModeOutput;

    // Custom fields add values
    foreach ($customFieldsColumns as $customFieldColumn) {
        $row[] = (strpos($customFieldColumn, 'date_picker_') !== false ? _d($aRow[$customFieldColumn]) : $aRow[$customFieldColumn]);
    }

    $row['DT_RowClass'] = 'has-row-options';

    $row = hooks()->apply_filters('expenses_table_row_data', $row, $aRow);

    $output['aaData'][] = $row;
}