<?php

defined('BASEPATH') or exit('No direct script access allowed');

$custom_fields = get_table_custom_fields('customers');
$this->ci->db->query("SET sql_mode = ''");

$aColumns = [
    //'1', // bulk actions 
    db_prefix() . 'tickets.ticketid', 
	db_prefix() . 'ticket_attachments.id', 
	db_prefix() . 'ticket_attachments.dateadded', 
	db_prefix() . 'ticket_attachments.file_name', 
	db_prefix() . 'ticket_attachments.file_cat', 
	db_prefix() . 'ticket_attachments_cats.attachment_cat_name', 
	db_prefix() . 'ticket_attachments.ticketid', 
	db_prefix() . 'ticket_attachments.filetype', 
	db_prefix() . 'clients.userid', 
	db_prefix() . 'clients.company', 
];
$sIndexColumn = 'ticketid';
$sTable       = db_prefix() . 'tickets';
$where        = [];
// Add blank where all filter can be stored
$filter = [];
$join = [
    'LEFT JOIN '.db_prefix() . 'ticket_attachments ON ' . db_prefix() . 'tickets.ticketid = ' . db_prefix() . 'ticket_attachments.ticketid
	
    LEFT JOIN '.db_prefix() . 'ticket_attachments_cats ON ' . db_prefix() . 'ticket_attachments.file_cat = ' . db_prefix() . 'ticket_attachments_cats.attachment_cat_id
	
    LEFT JOIN '.db_prefix() . 'clients ON ' . db_prefix() . 'tickets.userid = ' . db_prefix() . 'clients.userid
	
	', 
];

foreach ($custom_fields as $key => $field) {
    $selectAs = (is_cf_date($field) ? 'date_picker_cvalue_' . $key : 'cvalue_' . $key);
    array_push($customFieldsColumns, $selectAs);
    array_push($aColumns, 'ctable_' . $key . '.value as ' . $selectAs);
    array_push($join, 'LEFT JOIN ' . db_prefix() . 'customfieldsvalues as ctable_' . $key . ' ON ' . db_prefix() . 'clients.userid = ctable_' . $key . '.relid AND ctable_' . $key . '.fieldto="' . $field['fieldto'] . '" AND ctable_' . $key . '.fieldid=' . $field['id']);
}

$join = hooks()->apply_filters('customers_table_sql_join', $join);
 
$where  = [ ' AND tblticket_attachments.file_name  NOT LIKE "" ', ];
 
$aColumns = hooks()->apply_filters('customers_table_sql_columns', $aColumns);

// Fix for big queries. Some hosting have max_join_limit
if (count($custom_fields) > 4) {
    @$this->ci->db->query('SET SQL_BIG_SELECTS=1');
}

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [  
	'company', 
	'ctable_0.value as cvalue_0', 
	'ctable_1.value as cvalue_1', 
	'ctable_2.value as cvalue_2', 
	'ctable_3.value as cvalue_3' 
]);


$output  = $result['output'];
$rResult = $result['rResult'];
 

foreach ($rResult as $aRow) {
    $row = [];

  //  $row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow['id'] . '"><label></label></div>';

    $row[] = $aRow['tbltickets.ticketid'];
	
    //$row[] = _d($aRow['tblticket_attachments.dateadded']); 
    $row[] = $aRow['tblticket_attachments.dateadded']; 
	
	$iconebtn = '';
	if ($aRow['tblticket_attachments.filetype'] == 'application/pdf') { 
		$iconebtn = '<i class="mime mime-pdf"></i> '; 
	} else if ($aRow['tblticket_attachments.filetype'] == 'image/jpeg') { 
		$iconebtn = '<i class="mime mime-image"></i> '; 
	} else if ($aRow['tblticket_attachments.filetype'] == 'image/png') { 
		$iconebtn = '<i class="mime mime-image"></i> '; 
	} 
	
	$row[] = '<a href="/download/file/ticket/'.$aRow['tblticket_attachments.id'].'/" target="_blank" class="btn btn-default bold small" >'.$aRow['tblticket_attachments.file_name'].'</a>';
	
	$lien_complet = 'https://projets.ohelaterre.fr/download/preview_image?path=uploads/ticket_attachments/'.$aRow['tblticket_attachments.ticketid'].'/'.$aRow['tblticket_attachments.file_name'].'&type='.$aRow['tblticket_attachments.filetype'];
	
	if ($aRow['tblticket_attachments.filetype'] == 'application/pdf') {  
		
		//$pdfData = $this->documents_model->displayPdfFromUrl($lien_complet);
		//$pdfData =   ''.$lien_complet.'' ;
		 
		//$base64 = base64_encode($pdfData);
		//$row[] = '<a href="#" data-toggle="modal" data-target="#customer_iframe_modal" data-id="'.$aRow['tblticket_attachments.id'].'"  class="btn btn-default">Aperçu</a>';
		 
		$row[] = '<a href="#" onclick="iframe_pdf_preview('.$aRow['tblticket_attachments.id'].'); return false;"  class="btn btn-default">'.$iconebtn.' PDF</a>';
		
		//$row[] = '<div class="preview_image"><a href="'.$lien_complet.'" class="display-block mbot5"><div class="table-image"> <div class="text-center hide"><i class="fa fa-spinner fa-spin mtop30"></i></div><iframe src="data:application/pdf:base64,'.$base64.'" width="100%" height="200" class="img-table-loading"></iframe></div></a></div>';
	} else {
		//$row[] = '<div class="preview_image"><a href="'.$lien_complet.'" data-lightbox="customer-profile" class="display-block mbot5"><div class="table-image"> <div class="text-center hide"><i class="fa fa-spinner fa-spin mtop30"></i></div><img src="'.$lien_complet.'" class="img-table-loading" data-orig="'.$lien_complet.'"></div></a></div>';
		$row[] = '<div class="preview_image"><a href="'.$lien_complet.'" data-lightbox="customer-profile" class="btn btn-default">'.$iconebtn.' image</a></div>';
		
	}
	 
	if ($aRow['tblticket_attachments.file_cat'] === "0") {
		$classe_file_cat = "danger";
	} else if ($aRow['tblticket_attachments.file_cat'] === "1") {
		$classe_file_cat = "warning";
	} else {
		$classe_file_cat = "success"; 
	}
	 
	$row[] = '<a href="#" data-toggle="modal" data-target="#customer_document_modal" data-id="'.$aRow['tblticket_attachments.id'].'" class="text-'.$classe_file_cat.'">'.$aRow['tblticket_attachments_cats.attachment_cat_name'].'</a>';
	 	
    $row[] = '<a href="/admin/clients/client/'.$aRow['tblclients.userid'].'" target="_blank" class="btn  btn_layout_light small" >'.$aRow['tblclients.company'].'</a>';
	
    $row[] = '<a href="/admin/tickets/ticket/'.$aRow['tblticket_attachments.ticketid'].'#settings" target="_blank" class="small">'.$aRow['tblticket_attachments.ticketid'].'</a>'; 
	
if ($aRow['cvalue_1'] != "") { 
		$SIRET = '<a href="/admin/clients/client/'.$aRow['tblclients.userid'].'#custom_fields" target="_blank" class="" >'.$aRow['cvalue_1'].'</a>';
	} else {
		$SIRET = '<a href="/admin/clients/client/'.$aRow['tblclients.userid'].'#custom_fields" target="_blank" class="text-danger" >Manquant</a>';
	}
	if ($aRow['cvalue_5'] != "") {
		$IBAN = '<a href="/admin/clients/client/'.$aRow['tblclients.userid'].'#custom_fields" target="_blank" class="" >'.$aRow['cvalue_5'].'</a>';
	} else {
		$IBAN = '<a href="/admin/clients/client/'.$aRow['tblclients.userid'].'#custom_fields" target="_blank" class="text-danger" >Manquant</a>';
	} 
    $row[] = ''.$SIRET.'';
    $row[] = ''.$IBAN.'';
    /*$row[] = '
	PRESENTATION '.$aRow['cvalue_0'].'<br />
	SIRET : '.$aRow['cvalue_1'].'<br />
	IBAN : '.$aRow['cvalue_5'].'<br />
	N° bénéficiaire 2022 '.$aRow['cvalue_2'].'<br />
	cvalue_3 '.$aRow['cvalue_3'].'<br />
	Sociétaire '.$aRow['cvalue_4'].'<br />
	ID_WP '.$aRow['cvalue_6'].'<br />
	cvalue_7 '.$aRow['cvalue_7'].'<br />
	cvalue_8 '.$aRow['cvalue_8'].'<br /> 
	';
	*/
	
/* 
    $categoryOutput = '';

   // if (is_numeric($clientid)) {
        $categoryOutput = '<a href="' . admin_url('documents/list_documents/' . $aRow['ticketid']) . '">' . $aRow['category_name'] . '</a>';
   // } else {
   //     $categoryOutput = '<a href="' . admin_url('documents/list_documents/' . $aRow['id']) . '" onclick="init_document(' . $aRow['id'] . ');return false;">' . $aRow['category_name'] . '</a>';
  //  }


    $categoryOutput .= '<div class="row-options">';


    $categoryOutput .= '<a href="' . admin_url('documents/list_documents/' . $aRow['ticketid']) . '" onclick="init_document(' . $aRow['id'] . ');return false;">' . _l('view') . '</a>';

    if (has_permission('expenses', '', 'edit')) {
        $categoryOutput .= ' | <a href="' . admin_url('documents/document/' . $aRow['ticketid']) . '">' . _l('edit') . '</a>';
    }

    if (has_permission('expenses', '', 'delete')) {
        $categoryOutput .= ' | <a href="' . admin_url('documents/delete/' . $aRow['ticketid']) . '" class="text-danger _delete">' . _l('delete') . '</a>';
    }

    $categoryOutput .= '</div>';
    $row[] = $categoryOutput;

    
    $row[] = '<a href="' . admin_url('documents/list_documents/' . $aRow['ticketid']) . '" onclick="init_document(' . $aRow['ticketid'] . ');return false;">' . $aRow['document_name'] . '</a>';

    $outputReceipt = '';

    if (!empty($aRow['file_name'])) {
        $outputReceipt = '<a href="' . site_url('download/file/expense/' . $aRow['ticketid']) . '">' . $aRow['file_name'] . '</a>';
    }

    $row[] = $outputReceipt;


   // $row[] = '<a href="' . admin_url('projects/view/' . $aRow['project_id']) . '">' . $aRow['project_name'] . '</a>';

   // $row[] = '<a href="' . admin_url('clients/client/' . $aRow['clientid']) . '">' . $aRow['company'] . '</a>';



   // $row['DT_RowClass'] = 'has-row-options';

   // $row = hooks()->apply_filters('documents_table_row_data', $row, $aRow);
 */
    $output['aaData'][] = $row;
}