<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php
            echo form_open($this->uri->uri_string(), ['id' => 'invoice-form', 'class' => '_transaction_form invoice-form']);
            if (isset($invoice)) {
                echo form_hidden('isedit');
            }
            ?>
            <div class="col-md-12">
                <h4
                    class="tw-mt-0 tw-font-semibold tw-text-lg tw-text-neutral-700 tw-flex tw-items-center tw-space-x-2">
                    <span>
                        <?php echo isset($invoice) ? format_invoice_number($invoice) : _l('create_new_invoice'); ?>
                    </span>
                    <?php echo isset($invoice) ? format_invoice_status($invoice->status) : ''; ?>
                </h4>
                <?php $this->load->view('admin/invoices/invoice_template'); ?>
            </div>
            <?php echo form_close(); ?>
            <?php $this->load->view('admin/invoice_items/item'); ?>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
$(function() {
    validate_invoice_form();
    // Init accountacy currency symbol
    init_currency();
    // Project ajax search
    init_ajax_project_search_by_customer_id();
    // Maybe items ajax search
    init_ajax_search('items', '#item_select.ajax-search', undefined, admin_url + 'items/search');
	
	console.log("Mise à jour Achats vers Subvention");
	// Expense bill to popover data
	$("body").on(
		"change",
		".my_invoice_inc_expense_additional_info input",
		function () {
		  var _data_content = $(this).attr("data-content"),
			new_desc_value,
			desc_selector = $(
			  "[data-bill-expense=" +
				$(this).attr("data-id") +
				"] .item_long_description"
			);
		  current_desc_val = desc_selector.val();
		  current_desc_val = current_desc_val.trim();
		  if (_data_content !== "") {
			if ($(this).prop("checked") === true) {
			  new_desc_value = current_desc_val + "\n" + _data_content;
			  desc_selector.val(new_desc_value.trim());
			} else {
			  desc_selector.val(current_desc_val.replace("\n" + _data_content, ""));
			  // IN case there is no new line
			  desc_selector.val(current_desc_val.replace(_data_content, ""));
			}
		  }
		}
	);
				
	
    $('body').on('change', '#clientid', function() {
		var idclient = $(this).val();
        if (idclient != '') {
			ajout_iban_beneficiaire(idclient);
		} else {
			$('#clientnote').append('');  
		}
	});
	
});


function ajout_iban_beneficiaire(idclient) {
	//console.log("435");
	$.get(admin_url + 'invoices/get_client_iban/' + idclient + '/25',
		function(response) {
			$('#project_ajax_search_tableau').addClass('hide'); 
			$('#clientnote').html('');  					
			if (response != '') {
				$.each(response, function(index,value){
					//console.log( index + " : " + value+"  "); 
					if (value != "") {
						$('#clientnote').append('Le règlement se fera sur l\'IBAN '+value+'.');  
					} else {
						$('#clientnote').append('ATTENTION : IBAN BÉNÉFICIAIRE NON RENSEIGNÉ. Merci de mettre à jour le Profil du bénéficiaire.');  
					}
				}); 
			} else { 
				$('#clientnote').append('ATTENTION : IBAN BÉNÉFICIAIRE NON RENSEIGNÉ. Merci de mettre à jour le Profil du bénéficiaire.');  
			}  
		}, 'json'); 
				  
}


</script>
</body>

</html>