<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php if (count($expenses_to_bill) > 0) { ?>
	<h4 class="tw-font-semibold tw-mb-4"><?php echo _l('expenses_available_to_bill'); ?></h4>
	<?php foreach ($expenses_to_bill as $expense) {
			$additional_action = ''; ?>
		<?php if (!empty($expense['expense_name']) || !empty($expense['note'])) {
				ob_start(); ?>
			<p><?php echo _l('expense_include_additional_data_on_convert'); ?></p>
			<p class="bold hide"><?php echo _l('expense_add_edit_description'); ?> +</p>
			
			<?php if (!empty($expense['note'])) { ?>
				<div class="checkbox checkbox-primary my_invoice_inc_expense_additional_info">
					<input type="checkbox" id="inc_note" data-id="<?php echo $expense['id']; ?>" data-content="<?php echo $expense['note']; ?>">
					<label for="inc_note" data-toggle="tooltip" data-title="<?php echo html_escape($expense['note']); ?>">
						<?php echo _l('expense_add_edit_note'); ?></label>
				</div>
			<?php } ?>
			
			<?php if (!empty($expense['expense_name'])) { ?>
				<div class="checkbox checkbox-primary my_invoice_inc_expense_additional_info">
					<input type="checkbox" id="inc_name" data-id="<?php echo $expense['id']; ?>" data-content="Facture n°<?php echo $expense['expense_name']; ?>">
					<label for="inc_name" data-toggle="tooltip" data-title="<?php echo html_escape($expense['expense_name']); ?>">
						<?php echo _l('expense_name'); ?>
					</label>
				</div>
			<?php } ?>
			<?php 	
					$additional_action = ob_get_contents();
					//$additional_action = (html_escape($expense['note'])) .' - '. (html_escape($expense['expense_name']));
					$additional_action = htmlspecialchars($additional_action);
					ob_end_clean(); 
			}
		$expense['currency_data'] = $this->currencies_model->get($expense['currency']); 
		/* 
		
			<input type="checkbox" name="bill_expenses[]" value="<?php echo $additional_action; ?>"> 
		*/
		
		?>
		<div class="checkbox">
			<input type="checkbox" name="bill_expenses[]" value="<?php echo $expense['id']; ?>" data-toggle="popover" data-html="true" data-content="<?php echo $additional_action; ?>" data-placement="bottom">
			<label for="">
				<a href="<?php echo admin_url('expenses/list_expenses/' . $expense['id']); ?>" target="_blank" class="btn  btn_layout_light small"><?php echo $expense['category_name']; ?> !</a>
				<?php
					echo '' . $expense['date']; 
					echo ' • ' . app_format_money($expense['amount'], $expense['currency_data']);
					if (!empty($expense['expense_name'])) {
						echo ' • Facture n°' . $expense['expense_name'];
					} 
					if ($expense['tax'] != 0) {
						echo '<br /><span class="bold">' . _l('tax_1') . ':</span> ' . $expense['taxrate'] . '% (' . $expense['tax_name'] . ')';
						$total = $expense['amount'];
						$total += ($total / 100 * $expense['taxrate']);
					}
					if ($expense['tax2'] != 0) {
						echo '<br /><span class="bold">' . _l('tax_2') . ':</span> ' . $expense['taxrate2'] . '% (' . $expense['tax_name2'] . ')';
						$total += ($expense['amount'] / 100 * $expense['taxrate2']);
					}
					if ($expense['tax'] != 0 || $expense['tax2'] != 0) {
						echo '<p class="font-medium bold text-danger">' . _l('total_with_tax') . ': ' . app_format_money($total, $expense['currency_data']) . '</p>';
					} 
				?>
			</label>
		</div> 
<?php
	}
}
?>