<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php
            $rel_id = '';
            if (isset($expense)) {
                echo form_hidden('is_edit', 'true'); 
			} 
             ?>
            <?php echo form_open_multipart($this->uri->uri_string(), ['id' => 'expense-form', 'class' => 'dropzone dropzone-manual']) ; ?>
            <div class="col-md-6">
                <h4 class="tw-mt-0 tw-font-semibold tw-text-lg tw-text-neutral-700">
                    <?php echo $title; ?>
                </h4>
                <div class="panel_s">
                    <div class="panel-body">
					
					
                        <?php
                     if (isset($expense) && $expense->recurring_from != null) {
                         $recurring_expense = $this->expenses_model->get($expense->recurring_from);
                         echo '<div class="col-md-12"> <div class="alert alert-info">' . _l('expense_recurring_from', '<a href="' . admin_url('expenses/list_expenses/' . $expense->recurring_from) . '" target="_blank">' . $recurring_expense->category_name . (!empty($recurring_expense->expense_name) ? ' (' . $recurring_expense->expense_name . ')' : '') . '</a></div></div>');
                     }
                     ?>
					
					 <div class="col-md-12"> 
                        <div class="form-group select-placeholder">
                            <label for="clientid"
                                class="control-label"><?php echo _l('expense_add_edit_customer'); ?></label>
                            <select id="clientid" name="clientid" data-live-search="true" data-width="100%"
                                class="ajax-search"
                                data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                <?php 
								if (isset($expense)) {
									$selected = $expense->clientid ;
								} else if (isset($_GET['clientid'])) {	 
									$selected = $_GET['clientid'] ;
								} else if (isset($customer_id)) {
									$selected = $customer_id ;
								} else {
									$selected = '';
								} 
                        if ($selected != '') {
                            $rel_data = get_relation_data('customer', $selected);
                            $rel_val  = get_relation_values($rel_data, 'customer');
                            echo '<option value="' . $rel_val['id'] . '" selected>' . $rel_val['name'] . '</option>';
                        } ?>
                            </select>
							<div id="project_ajax_search" class="hide  text-center" style="width: 100%;margin:10px 0 -20px 0;padding: 5px;background: #fbf2ea;">
								<div id="project_ajax_search_contrats"><p style="color:red;" class="bold text-uppercase">Merci de sélectionner un bénéficiaire.</p></div>
								<div id="project_ajax_search_files"></div>
							</div>  
                        </div>
                        <hr class="hr-panel-separator" />
					</div>
					
					 <div class="col-md-12"> 	
                        <?php
                     $selected = (isset($expense) ? $expense->category : '');
                     if (is_admin() || get_option('staff_members_create_inline_expense_categories') == '1') {
                         echo render_select_with_input_group('category', $categories, ['id', 'name', 'description', 'densite', 'subvention'], 'expense_category', $selected, '<div class="input-group-btn"><a href="#" class="btn btn-default" onclick="new_category();return false;"><i class="fa fa-plus"></i></a></div>');
                     } else {
                         echo render_select('category', $categories, ['id', 'name', 'description'], 'expense_category', $selected);
                     }
                     ?>
						<div id="project_ajax_search_category" class="hide" style="padding:10px 10px 0 10px;border: 1px solid #85cee4;"></div> 
					</div> 
					  
					 <div class="col-md-12">
					 
						 <div class="col-md-6"> 
							   <p class="small"><br /><i class="fa-regular fa-circle-question pull-left tw-mt-0.5 tw-mr-1"></i> Sélectionner le produit éligible à l'action contractualisée, puis saisir la quantité du produit facturée pour voir apparaître la subvention théorique équivalente. En fonction du contrat établi, le montant de la subvention calculé pourra être ajusté manuellement à la baisse (jamais à la hausse).</p><p><small class="label label-info bold">Formule du calcul :<br />(kg achetés / densité éligible à l'hectare) * montant subventionné à l'hectare</small></p>
						 </div>
						 <div class="col-md-6">
							 <div class="col-md-12">
								<div class="form-group" app-field-wrapper="qte">
									<label for="qte" class="control-label">Quantité (kg)</label>
									<input type="number" id="qte" class="form-control" value="">
									<input type="hidden" id="densite" value="0" />
									<input type="hidden" id="subvention" value="0" />
									<input type="hidden" id="montant" value="<?php $value = (isset($expense) ? substr(($expense->amount),0,-3) : '0'); echo $value; ?>" />
								</div>
							 </div>
							 <div class="col-md-12">
								   <?php echo render_input('amount', 'Equivalent subvention (€)', $value, 'number'); /* , ['readonly' => 'readonly'] */
								 $hide_billable_options = 'hide';

								 if ((isset($expense) && ($expense->billable == 1 || $expense->clientid != 0)) || isset($customer_id)) {
									 $hide_billable_options = '';
								 }
								 ?> 
							 </div>
						 </div>
					 </div>
					 
					 <div class="col-md-3 hide ">
					 
						<label for="billable" class="control-label" <?php if (isset($expense) && $expense->invoiceid !== null) {
                         echo 'data-toggle="tooltip" title="' . _l('expense_already_invoiced') . '"';
                     } ?>><?php echo _l('expense_add_edit_billable'); ?> ?</label>
                        <div class="checkbox checkbox-primary billable <?php echo $hide_billable_options; ?>">
                            <input type="checkbox" id="billable" <?php if (isset($expense) && $expense->invoiceid !== null) {
                         echo 'disabled';
                     } ?> name="billable" <?php if (isset($expense)) {
                         if ($expense->billable == 1) {
                             echo 'checked';
                         } else { 
                             echo 'checked';
                         }
                     } else { 
                             echo 'checked';
                         }; ?>>
                            <label for="billable" <?php if (isset($expense) && $expense->invoiceid !== null) {
                         echo 'data-toggle="tooltip" title="' . _l('expense_already_invoiced') . '"';
                     } ?>></label>
                        </div>
					 </div>
  
						
                        <?php $hide_project_selector = ' hide';
                     // Show selector only if expense is already added and there is no client linked to the expense or isset customer id
                     if ((isset($expense) && $expense->clientid != 0) || isset($customer_id)) {
                         $hide_project_selector = '';
                     }
                     ?>
                        <div class="hide form-group projects-wrapper<?php echo $hide_project_selector; ?>">
                            <label for="project_id"><?php echo _l('project'); ?></label>
                            <div id="project_ajax_search_wrapper">
                                <select name="project_id" id="project_id" class="projects ajax-search"
                                    data-live-search="true" data-width="100%"
                                    data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                    <?php if (isset($expense) && $expense->project_id != 0) {
                         echo '<option value="' . $expense->project_id . '" selected>' . get_project_name_by_id($expense->project_id) . '</option>';
                     }
                           ?>
                                </select>
                            </div>
                        </div>
                        <div class="btn-bottom-toolbar text-right">
                            <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <h4 class="tw-mt-0 tw-font-semibold tw-text-lg tw-text-neutral-700">
                    <?php echo _l('advanced_options'); ?>
                </h4>
                <div class="panel_s">
                    <div class="panel-body"> 
						<div class="row">
							 <div class="col-md-6"> 
								<?php $value = (isset($expense) ? _d($expense->date) : _d(date('Y-m-d')));
								 $date_attrs     = [];
								 if (isset($expense) && $expense->recurring > 0 && $expense->last_recurring_date != null) {
									 $date_attrs['disabled'] = true;
								 }
								 ?>
								<?php echo render_date_input('date', 'expense_add_edit_date', $value, $date_attrs);
								$value = (isset($expense) ? $expense->amount : ''); ?>
							 </div>
							<div class="col-md-6"> 
								<?php hooks()->do_action('before_expense_form_name', isset($expense) ? $expense : null); ?>

								<i class="hide fa-regular fa-circle-question pull-left tw-mt-0.5 tw-mr-1" data-toggle="tooltip"
									data-title="<?php echo _l('expense_name_help'); ?> - <?php echo _l('expense_field_billable_help', _l('expense_name')); ?>"></i>
								<?php $value = (isset($expense) ? $expense->expense_name : ''); ?>
								<?php echo render_input('expense_name', 'expense_name', $value); ?>
							</div>	 
							<?php if (!isset($expense) || (isset($expense) && $expense->attachment == '')) { ?> 
								<div class="col-md-6 hide">
									<div id="dropzoneDragArea" class="dz-default dz-message">
										<span><?php echo _l('expense_add_edit_attach_receipt'); ?></span>
									</div>
								</div> 
							<div class="dropzone-previews"></div>
							<?php } ?>
						</div>	

                        <?php if (isset($expense) && $expense->attachment !== '') { ?>
                        <div class="row hide">
                            <div class="col-md-10">
                                <i class="<?php echo get_mime_class($expense->filetype); ?>"></i> <a
                                    href="<?php echo site_url('download/file/expense/' . $expense->expenseid); ?>" class="btn  btn_layout_light small"><?php echo $expense->attachment; ?></a>
                            </div>
                            <?php if ($expense->attachment_added_from == get_staff_user_id() || is_admin()) { ?>
                            <div class="col-md-2 text-right">
                                <a href="<?php echo admin_url('expenses/delete_expense_attachment/' . $expense->expenseid); ?>"
                                    class="text-danger _delete"><i class="fa fa fa-times"></i></a>
                            </div>
                            <?php } ?>
                        </div>
                        <?php } ?>
                        <hr class="hr-panel-separator" />
						
                        <i class="hide fa-regular fa-circle-question pull-left tw-mt-0.5 tw-mr-1" data-toggle="tooltip"
                            data-title="<?php echo _l('expense_field_billable_help', _l('expense_add_edit_note')); ?>"></i>
                        <?php $value = (isset($expense) ? $expense->note : ''); ?>
                        <?php echo render_textarea('note', 'expense_add_edit_note', $value, ['rows' => 4], []); ?>
					
					
                        <?php $rel_id = (isset($expense) ? $expense->expenseid : false); ?>
                        <?php echo render_custom_fields('expenses', $rel_id); ?>
						
					
					
					
                        <div class=" hide">
                        <?php
							 $currency_attr = ['disabled' => true, 'data-show-subtext' => true];

							 $currency_attr = apply_filters_deprecated('expense_currency_disabled', [$currency_attr], '2.3.0', 'expense_currency_attributes');

							 foreach ($currencies as $currency) {
								 if ($currency['isdefault'] == 1) {
									 $currency_attr['data-base'] = $currency['id'];
								 }
								 if (isset($expense)) {
									 if ($currency['id'] == $expense->currency) {
										 $selected = $currency['id'];
									 }
									 if ($expense->billable == 0) {
										 if ($expense->clientid != 0) {
											 $c = $this->clients_model->get_customer_default_currency($expense->clientid);
											 if ($c != 0) {
												 $customer_currency = $c;
											 }
										 }
									 }
								 } else {
									 if (isset($customer_id)) {
										 $c = $this->clients_model->get_customer_default_currency($customer_id);
										 if ($c != 0) {
											 $customer_currency = $c;
										 }
									 }
									 if ($currency['isdefault'] == 1) {
										 $selected = $currency['id'];
									 }
								 }
							 }
							 $currency_attr = hooks()->apply_filters('expense_currency_attributes', $currency_attr);
						?>
                        </div>
                        <div id="expense_currency" class=" hide">
                            <?php echo render_select('currency', $currencies, ['id', 'name', 'symbol'], 'expense_currency', $selected, $currency_attr); ?>
                        </div>
                        <div class="row hide">
                            <div class="col-md-6 hide">
                                <div class="form-group select-placeholder">
                                    <label class="control-label" for="tax"><?php echo _l('tax_1'); ?></label>
                                    <select class="selectpicker display-block" data-width="100%" name="tax"
                                        data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                        <option value=""><?php echo _l('no_tax'); ?></option>
                                        <?php foreach ($taxes as $tax) {
												 $selected = '';
												 if (isset($expense)) {
													 if ($tax['id'] == $expense->tax) {
														 $selected = 'selected';
													 }
												 } ?>
											<option value="<?php echo $tax['id']; ?>" <?php echo $selected; ?>
												data-percent="<?php echo $tax['taxrate']; ?>"
												data-subtext="<?php echo $tax['name']; ?>">
												<?php echo $tax['taxrate']; ?>%
											</option>
                                        <?php } ?>
                                    </select>

                                </div>
                            </div>
                            <div class="col-md-6 hide">
                                <div class="form-group select-placeholder">
                                    <label class="control-label" for="tax2"><?php echo _l('tax_2'); ?></label>
                                    <select class="selectpicker display-block" data-width="100%" name="tax2"
                                        data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>" <?php if (!isset($expense) || isset($expense) && $expense->tax == 0) {
											 echo 'disabled';
										 } ?>>
                                        <option value=""><?php echo _l('no_tax'); ?></option>
                                        <?php foreach ($taxes as $tax) {
											 $selected = '';
											 if (isset($expense)) {
												 if ($tax['id'] == $expense->tax2) {
													 $selected = 'selected';
												 }
											 } ?>
											<option value="<?php echo $tax['id']; ?>" <?php echo $selected; ?>
												data-percent="<?php echo $tax['taxrate']; ?>"
												data-subtext="<?php echo $tax['name']; ?>">
												<?php echo $tax['taxrate']; ?>%
											</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <?php if (!isset($expense)) { ?>
                            <div class="col-md-12 hide" id="tax_subtract">
                                <div class="alert alert-info">
                                    <div class="checkbox checkbox-primary no-margin">
                                        <input type="checkbox" id="tax1_included">
                                        <label for="tax1_included">
                                            <?php echo _l('subtract_tax_total_from_amount', '<span id="tax_subtract_total" class="bold"></span>'); ?>
                                        </label>
                                    </div>
                                    <p class="tw-text-sm tw-mt-2 tw-ml-7">
                                        <?php echo _l('expense_subtract_info_text'); ?>
                                    </p>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                        <div class="clearfix mtop15 hide"></div>
                        <div class="row hide">
                            <div class="col-md-6">
                                <?php $selected = (isset($expense) ? $expense->paymentmode : ''); ?>
                                <?php echo render_select('paymentmode', $payment_modes, ['id', 'name'], 'payment_mode', $selected); ?>
                            </div>
                            <div class="col-md-6 hide">
                                <?php $value = (isset($expense) ? $expense->reference_no : ''); ?>
                                <?php echo render_input('reference_no', 'expense_add_edit_reference_no', $value); ?>
                            </div>
                        </div>
                        <div class="form-group select-placeholder hide"
                            <?php if (isset($expense) && !empty($expense->recurring_from)) { ?> data-toggle="tooltip"
                            data-title="<?php echo _l('create_recurring_from_child_error_message', [_l('expense_lowercase'), _l('expense_lowercase'), _l('expense_lowercase')]); ?>"
                            <?php } ?>>
                            <label for="repeat_every"
                                class="control-label"><?php echo _l('expense_repeat_every'); ?></label>
                            <select name="repeat_every" id="repeat_every" class="selectpicker" data-width="100%"
                                data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>"
                                <?php if (isset($expense) && !empty($expense->recurring_from)) { ?> disabled <?php } ?>>
                                <option value=""></option>
                                <option value="1-week" <?php if (isset($expense) && $expense->repeat_every == 1 && $expense->recurring_type == 'week') {
									 echo 'selected';
								 } ?>><?php echo _l('week'); ?></option>
											<option value="2-week" <?php if (isset($expense) && $expense->repeat_every == 2 && $expense->recurring_type == 'week') {
									 echo 'selected';
								 } ?>>2 <?php echo _l('weeks'); ?></option>
											<option value="1-month" <?php if (isset($expense) && $expense->repeat_every == 1 && $expense->recurring_type == 'month') {
									 echo 'selected';
								 } ?>>1 <?php echo _l('month'); ?></option>
											<option value="2-month" <?php if (isset($expense) && $expense->repeat_every == 2 && $expense->recurring_type == 'month') {
									 echo 'selected';
								 } ?>>2 <?php echo _l('months'); ?></option>
											<option value="3-month" <?php if (isset($expense) && $expense->repeat_every == 3 && $expense->recurring_type == 'month') {
									 echo 'selected';
								 } ?>>3 <?php echo _l('months'); ?></option>
											<option value="6-month" <?php if (isset($expense) && $expense->repeat_every == 6 && $expense->recurring_type == 'month') {
									 echo 'selected';
								 } ?>>6 <?php echo _l('months'); ?></option>
											<option value="1-year" <?php if (isset($expense) && $expense->repeat_every == 1 && $expense->recurring_type == 'year') {
									 echo 'selected';
								 } ?>>1 <?php echo _l('year'); ?></option>
											<option value="custom" <?php if (isset($expense) && $expense->custom_recurring == 1) {
									 echo 'selected';
								 } ?>><?php echo _l('recurring_custom'); ?></option>
                            </select>
                        </div>
                        <div class="recurring_custom <?php if ((isset($expense) && $expense->custom_recurring != 1) || (!isset($expense))) {
                         echo 'hide';
                     } ?>">
                            <div class="row hide">
                                <div class="col-md-6">
                                    <?php $value = (isset($expense) && $expense->custom_recurring == 1 ? $expense->repeat_every : 1); ?>
                                    <?php echo render_input('repeat_every_custom', '', $value, 'number', ['min' => 1]); ?>
                                </div>
                                <div class="col-md-6">
                                    <select name="repeat_type_custom" id="repeat_type_custom" class="selectpicker"
                                        data-width="100%"
                                        data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                        <option value="day" <?php if (isset($expense) && $expense->custom_recurring == 1 && $expense->recurring_type == 'day') {
											 echo 'selected';
										 } ?>><?php echo _l('expense_recurring_days'); ?></option>
															<option value="week" <?php if (isset($expense) && $expense->custom_recurring == 1 && $expense->recurring_type == 'week') {
											 echo 'selected';
										 } ?>><?php echo _l('expense_recurring_weeks'); ?></option>
															<option value="month" <?php if (isset($expense) && $expense->custom_recurring == 1 && $expense->recurring_type == 'month') {
											 echo 'selected';
										 } ?>><?php echo _l('expense_recurring_months'); ?></option>
															<option value="year" <?php if (isset($expense) && $expense->custom_recurring == 1 && $expense->recurring_type == 'year') {
											 echo 'selected';
										 } ?>><?php echo _l('expense_recurring_years'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div id="cycles_wrapper" class="<?php if (!isset($expense) || (isset($expense) && $expense->recurring == 0)) {
                         echo ' hide';
                     }?>">
                            <?php $value = (isset($expense) ? $expense->cycles : 0); ?>
                            <div class="form-group recurring-cycles">
                                <label for="cycles"><?php echo _l('recurring_total_cycles'); ?>
                                    <?php if (isset($expense) && $expense->total_cycles > 0) {
                         echo '<small>' . _l('cycles_passed', $expense->total_cycles) . '</small>';
                     }
                           ?>
                                </label>
                                <div class="input-group">
                                    <input type="number" class="form-control" <?php if ($value == 0) {
                               echo ' disabled';
                           } ?> name="cycles" id="cycles" value="<?php echo $value; ?>" <?php if (isset($expense) && $expense->total_cycles > 0) {
                               echo 'min="' . ($expense->total_cycles) . '"';
                           } ?>>
                                    <div class="input-group-addon">
                                        <div class="checkbox">
                                            <input type="checkbox" <?php if ($value == 0) {
                               echo ' checked';
                           } ?> id="unlimited_cycles">
                                            <label for="unlimited_cycles"><?php echo _l('cycles_infinity'); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="hide">
                            <?php
                        $hide_invoice_recurring_options = 'hide';
                        if (isset($expense) && $expense->billable == 1) {
                            $hide_invoice_recurring_options = '';
                        }
                        ?>
                            <div
                                class="checkbox checkbox-primary billable_recurring_options <?php echo $hide_invoice_recurring_options; ?>">
                                <input type="checkbox" id="create_invoice_billable" name="create_invoice_billable" <?php if (isset($expense)) {
                            if ($expense->create_invoice_billable == 1) {
                                echo 'checked';
                            }
                        }; ?>>
                                <label for="create_invoice_billable"><i class="fa-regular fa-circle-question"
                                        data-toggle="tooltip"
                                        title="<?php echo _l('expense_recurring_autocreate_invoice_tooltip'); ?>"></i>
                                    <?php echo _l('expense_recurring_auto_create_invoice'); ?></label>
                            </div>
                        </div>
                        <div
                            class="hide checkbox checkbox-primary billable_recurring_options <?php echo $hide_invoice_recurring_options; ?>">
                            <input type="checkbox" name="send_invoice_to_customer" id="send_invoice_to_customer" <?php if (isset($expense)) {
                            if ($expense->send_invoice_to_customer == 1) {
                                echo 'checked';
                            }
                        }; ?>>
                            <label
                                for="send_invoice_to_customer"><?php echo _l('expense_recurring_send_custom_on_renew'); ?></label>
                        </div>
                    </div>
                </div>
            </div>
            <?php hooks()->do_action('before_expense_form_template_close', $expense ?? null); ?>
            <?php echo form_close(); ?>
        </div>
        <div class="btn-bottom-pusher"></div>
    </div>
</div>
<?php $this->load->view('admin/expenses/expense_category'); ?>
<?php init_tail(); ?>
<script>
var customer_currency = '';
Dropzone.options.expenseForm = false;
var expenseDropzone;
init_ajax_project_search_by_customer_id();
var selectCurrency = $('select[name="currency"]');
<?php if (isset($customer_currency)) { ?>
var customer_currency = '<?php echo $customer_currency; ?>';
<?php } ?>
$(function() {
    $('body').on('change', '#project_id', function() {
        var project_id = $(this).val();
        if (project_id != '') {
            if (customer_currency != 0) {
                selectCurrency.val(customer_currency);
                selectCurrency.selectpicker('refresh');
            } else {
                set_base_currency();
            }
        } else {
            do_billable_checkbox();
        }
    });
	
	
    $('body').on('change', '#clientid', function() {
		var idclient = $(this).val();
        if (idclient != '') {
			//console.log("clientid 458");
			expense_clientid_select(idclient);
			voir_contrats_par_beneficiaire(idclient);
        }
    });
	
	<?php if (isset($_GET['clientid'])) { ?>
		var idclient = <?php echo $_GET['clientid']; ?>;
        if (idclient != '') {
			$('#clientid').trigger("change");
			//console.log("clientid change 466");
			expense_clientid_select(idclient);
			voir_contrats_par_beneficiaire(idclient);
        }
	
	<?php } ?>
	 

    if ($('#dropzoneDragArea').length > 0) {
        expenseDropzone = new Dropzone("#expense-form", appCreateDropzoneOptions({
            autoProcessQueue: false,
            clickable: '#dropzoneDragArea',
            previewsContainer: '.dropzone-previews',
            addRemoveLinks: true,
            maxFiles: 1,
            success: function(file, response) {
                response = JSON.parse(response);
                if (this.getUploadingFiles().length === 0 && this.getQueuedFiles().length ===
                    0) {
                    window.location.assign(response.url);
                }
            },
        }));
    }

    appValidateForm($('#expense-form'), {
        category: 'required',
        date: 'required',
        amount: 'required',
        currency: 'required',
        repeat_every_custom: {
            min: 1
        },
    }, expenseSubmitHandler);

    $('input[name="billable"]').on('change', function() {
        do_billable_checkbox();
    });

    $('#repeat_every').on('change', function() {
        if ($(this).selectpicker('val') != '' && $('input[name="billable"]').prop('checked') == true) {
            $('.billable_recurring_options').removeClass('hide');
        } else {
            $('.billable_recurring_options').addClass('hide');
        }
    });

    // hide invoice recurring options on page load
    $('#repeat_every').trigger('change');

    $('select[name="clientid"]').on('change', function() {
        customer_init();
        do_billable_checkbox(); 
		var clientid = $('select[name="clientid"]').val();
		voir_contrats_par_beneficiaire(clientid);
		//console.log("clientid"+clientid);
        $('input[name="billable"]').trigger('change');
    });
    $('select[name="category"]').on('change', function() { 
		var category = $('select[name="category"]').val();
		if (category != 0) {
			voir_info_par_category(category);
			//console.log(" category : "+category); 
		} else {
			//console.log("Aucune catégorie");
			$('#note').html('');
		}
    });
    $("#qte").on('click blur change', function() { 
		var qte = $("#qte").val();
		var densite = $("#densite").val(); 
		var subvention = $("#subvention").val(); 
		var montant = (qte / densite) * subvention ;
			//console.log(" montant =  : "+ montant );
			$("#amount").val(montant);
		 
    });

	
    <?php if (!isset($expense)) { ?>
	
    $('select[name="tax"], select[name="tax2"]').on('change', function() {

        delay(function() {
            var $amount = $('#amount'),
                taxDropdown1 = $('select[name="tax"]'),
                taxDropdown2 = $('select[name="tax2"]'),
                taxPercent1 = parseFloat(taxDropdown1.find('option[value="' + taxDropdown1
                    .val() + '"]').attr('data-percent')),
                taxPercent2 = parseFloat(taxDropdown2.find('option[value="' + taxDropdown2
                    .val() + '"]').attr('data-percent')),
                total = $amount.val();

            if (total == 0 || total == '') {
                return;
            }

            if ($amount.attr('data-original-amount')) {
                total = $amount.attr('data-original-amount');
            }

            total = parseFloat(total);

            if (taxDropdown1.val() || taxDropdown2.val()) {

                $('#tax_subtract').removeClass('hide');

                var totalTaxPercentExclude = taxPercent1;
                if (taxDropdown2.val()) {
                    totalTaxPercentExclude += taxPercent2;
                }

                var totalExclude = accounting.toFixed(total - exclude_tax_from_amount(
                    totalTaxPercentExclude, total), app.options.decimal_places);
                $('#tax_subtract_total').html(accounting.toFixed(totalExclude, app.options
                    .decimal_places));
            } else {
                $('#tax_subtract').addClass('hide');
            }
            if ($('#tax1_included').prop('checked') == true) {
                subtract_tax_amount_from_expense_total();
            }
        }, 200);
    });

    $('#amount').on('blur', function() {
        $(this).removeAttr('data-original-amount');
        if ($(this).val() == '' || $(this).val() == '') {
            $('#tax1_included').prop('checked', false);
            $('#tax_subtract').addClass('hide');
        } else {
            var tax1 = $('select[name="tax"]').val();
            var tax2 = $('select[name="tax2"]').val();
            if (tax1 || tax2) {
                setTimeout(function() {
                    $('select[name="tax2"]').trigger('change');
                }, 100);
            }
        }
    })

    $('#tax1_included').on('change', function() {

        var $amount = $('#amount'),
            total = parseFloat($amount.val());

        // da pokazuva total za 2 taxes  Subtract TAX total (136.36) from expense amount
        if (total == 0) {
            return;
        }

        if ($(this).prop('checked') == false) {
            $amount.val($amount.attr('data-original-amount'));
            return;
        }

        subtract_tax_amount_from_expense_total();
    });
    <?php } ?>
	
	
	
    <?php if (isset($expense)) { ?> 
	
        $('#clientid').trigger('change');
        $('#category').trigger('change');
		
		
        //$('#qte').trigger('change');
		/*  
		var montant = $("#montant").val();
		var densite = $("#densite").val(); 
		var subvention = $("#subvention").val(); 
		var qte = ( montant /subvention ) * densite ;
		
		console.log(" montant "+montant);
		console.log(" densite "+densite);
		console.log(" subvention "+subvention);
		console.log(" qte "+qte);
		$("#qte").attr('value', qte);
		
		$('#amount').attr('value', montant);
		$('#amount').trigger('change'); */
	
    <?php } ?>
	
});


function expense_clientid_select(clientid) {
    var serverData = {}; 
    init_ajax_search(clientid, serverData);
}

function voir_contrats_par_beneficiaire(idclient) { 
	$.get(admin_url + 'expenses/get_user_proposals/' + idclient + '/0',
		function(response) {
			$('#project_ajax_search').addClass('hide'); 
			$('#project_ajax_search_contrats').html('');   					
			if (!$.trim(response)){   
				$('#project_ajax_search_contrats').html(''); 
			} else {   
				//console.log(response); 
				//<a href="/admin/proposals#'+response.id+'?tab=settings" target="_blank" class="btn btn_layout_light small" >Contrat #'+response.id+'</a> 
				var proposals = "";  		
				if (response != '') {
					$.each(response, function(index,value){
						//console.log( index + " : " + value.ticketid + "("+ value.subject +") "); 
						if ((value.status) == '1') {
							btnstatut = '<span class="label label-default  s-status proposal-status-1">Ouvert</span>'; 
						} else if ((value.status) == '2') {
							btnstatut = '<span class="label label-danger  s-status proposal-status-2">Décliné</span>'; 
						} else if ((value.status) == '3') {
							btnstatut = '<span class="label label-success  s-status proposal-status-3">Accepté</span>'; 
						} else if ((value.status) == '4') {
							btnstatut = '<span class="label label-info  s-status proposal-status-4">Envoyé</span>'; 
						} else if ((value.status) == '5') {
							btnstatut = '<span class="label label-info  s-status proposal-status-5">Contrôlé</span>'; 
						} else if ((value.status) == '6') {
							btnstatut = '<span class="label label-default  s-status proposal-status-6">Brouillon</span>'; 
						} else {
							btnstatut = '<span class="label label-success  s-status proposal-status-'+value.status+'">Statut '+value.status+'</span>';
						}
						proposals += '<p><a href="/proposal/'+value.id+'/'+value.hash+'" target="_blank" class="btn btn_layout_light small" style="margin: -2px 4px 0 -2px;">Contrat #'+value.id+'</a>'+btnstatut+'</p><p>'+value.description+'</p><p style="border-bottom: 2px dashed white; padding-bottom:5px;"><strong>Subvention accordée : '+(value.total)+'€ HT</strong></p>';
					}); 
					//(value.total).slice(0, -3)
				} else { 
					proposals += '<p class="bold text-danger text-center">Aucune contrat enregistré pour ce bénéficiaire <a href="/admin/clients/client/'+ value.rel_id +'?group=tickets" target="_blank" class="btn btn_layout_light small" >consulter</a></p>';   	 	
				}  
				$('#project_ajax_search_contrats').html(''+proposals+'');  
			} 
			$('#project_ajax_search').removeClass('hide');  
		}, 'json'); 
		voir_files_par_beneficiaire(idclient);   
}

function voir_files_par_beneficiaire(idclient) { 
	$.get(admin_url + 'expenses/get_user_files/' + idclient + '/0',
		function(response) {
			$('#project_ajax_search').addClass('hide'); 
			$('#project_ajax_search_files').html('');   					
			if (!$.trim(response)){   
				$('#project_ajax_search_files').html(''); 
			} else {   
			  //console.log(response); 
				//<a href="/admin/proposals#'+response.id+'?tab=settings" target="_blank" class="btn btn_layout_light small" >Contrat #'+response.id+'</a> 
				var pj_customer = "";
				var pj_tickets = "";
				var pj_proposals = "";
				  
				if ($.trim(response.attachments_customer)){ 
					var pjcustomer = response.attachments_customer[0];
					$.each(pjcustomer, function(index,value){
						//console.log( index + " : " + pjcustomer.file_name + "(status : "+ pjcustomer.filetype +") ");
						pj_customer = '<a href="/download/file/client/'+pjcustomer.attachment_key+'" target="_blank" class="bold small" >'+pjcustomer.file_name+'</a> '; 
					});
				}
				
				if ($.trim(response.attachments_tickets)){ 
					var pjtickets = response.attachments_tickets[0];
						//pj_tickets = '<tr><td colspan="2">PJ Demandes de subvention :</td></tr>'; 
					$.each(pjtickets, function(index,value){
						// console.log("615"+ pjtickets);
						// console.log( index + " : " + pjtickets.file_name + "(status : "+ pjtickets.filetype +") ");
						pj_tickets = '<a href="/download/file/ticket/'+pjtickets.id+'/" target="_blank" class="bold small" >'+pjtickets.file_name+'</a> '; 
						
						//<iframe src="/uploads/ticket_attachments/'+pjtickets.ticketid+'/'+pjtickets.file_name+'" height="200" width="300"></iframe>
					});
				}
				
				if ($.trim(response.attachments_proposals)){ 
					var pjproposals = response.attachments_proposals[0];
					$.each(pjproposals, function(index,value){
						//console.log( index + " : " + pjproposals.file_name + "(status : "+ pjproposals.filetype +") ");
						pj_proposals = '<a href="/download/file/proposal/'+attachment_key+'" target="_blank" class="bold small" >'+pjproposals.file_name+'</a> '; 
					});
				}
			
				$('#project_ajax_search_files').html('<p style="margin-bottom: 20px;" class="bold text-uppercase">Fichiers bénéficiaire</p><p>'+pj_tickets+''+pj_proposals+''+pj_customer+'</p>'); 
				
				 // $.each(response, function(index,value){
				 	//console.log( index + " : " + response.total + "(status : "+ response.status +") "); 
				// });  
			} 
				$('#project_ajax_search').removeClass('hide');  
		}, 'json'); 
				  
}

function voir_info_par_category(category) {
	$.get(admin_url + 'expenses/get_category/' + category + '/',
		function(response) {
			$('#project_ajax_search_category').addClass('hide'); 
			$('#project_ajax_search_category').html('');   	
			//console.log(response); 	
 
  
				$('#densite').val('0');
				$('#subvention').val('0');
				//$('#amount').val('0');
	 		
	
				$('#note').html('');
			
			if ((!$.trim(response)) || (!$.trim(category))) {   
				$('#project_ajax_search_category').html('p class="bold text-danger text-center" ><a href="/admin/expenses/categories" target="_blank" class="btn btn_layout_light small" >Aucun produit</a></p>'); 
				$('#densite').val('0');
				$('#subvention').val('0');
				//$('#amount').val('0');
				$('#note').html(''); 
			} else {  
				$('#project_ajax_search_category').html('<p><strong>Produit éligible pour l\'action :</strong> <a href="/admin/expenses/categories" class="bold" title="Modifier les produits éligibles">'+response.description+'</a><br /><strong>Densité :</strong> '+response.densite+' kg/ha.<br /><strong>Subvention accordée :</strong> '+response.subvention+' €/ha.</p>'); 
				$('#densite').val(response.densite); 
				$('#subvention').val(response.subvention); 
				$('#note').html('Produit éligible pour l\'action '+response.description+'. | Densité éligible de '+response.densite+' kg/ha. | Subvention accordée : '+response.subvention+' €/ha.'); 
				
				<?php if (isset($expense)) { ?> 
					console.log("812");
		 
					var montant= $("#amount").val();   
					var densite = $("#densite").val(); 
					var subvention = $("#subvention").val(); 
					var qte = ( montant /subvention ) * densite ;
					 
							
					console.log(" montant "+montant);
					console.log(" densite "+densite);
					console.log(" subvention "+subvention);
					console.log(" qte "+qte);
					$("#qte").attr('value', qte);
					  
				<?php } ?>	
				
			}
			$('#project_ajax_search_category').removeClass('hide');  
		}, 'json');

	
				  
}

function subtract_tax_amount_from_expense_total() {
    var $amount = $('#amount'),
        total = parseFloat($amount.val()),
        taxDropdown1 = $('select[name="tax"]'),
        taxDropdown2 = $('select[name="tax2"]'),
        taxRate1 = parseFloat(taxDropdown1.find('option[value="' + taxDropdown1.val() + '"]').attr('data-percent')),
        taxRate2 = parseFloat(taxDropdown2.find('option[value="' + taxDropdown2.val() + '"]').attr('data-percent'));

    var totalTaxPercentExclude = taxRate1;
    if (taxRate2) {
        totalTaxPercentExclude += taxRate2;
    }

    if ($amount.attr('data-original-amount')) {
        total = parseFloat($amount.attr('data-original-amount'));
    }

    $amount.val(exclude_tax_from_amount(totalTaxPercentExclude, total));

    if ($amount.attr('data-original-amount') == undefined) {
        $amount.attr('data-original-amount', total);
    }
}

function customer_init() {
    var customer_id = $('select[name="clientid"]').val();
    var projectAjax = $('select[name="project_id"]');
    var clonedProjectsAjaxSearchSelect = projectAjax.html('').clone();
    var projectsWrapper = $('.projects-wrapper');
    projectAjax.selectpicker('destroy').remove();
    projectAjax = clonedProjectsAjaxSearchSelect;
    $('#project_ajax_search_wrapper').append(clonedProjectsAjaxSearchSelect);
    init_ajax_project_search_by_customer_id();
    if (!customer_id) {
        set_base_currency();
        projectsWrapper.addClass('hide');
    }
    $.get(admin_url + 'expenses/get_customer_change_data/' + customer_id, function(response) {
        if (customer_id && response.customer_has_projects) {
            projectsWrapper.removeClass('hide');
        } else {
            projectsWrapper.addClass('hide');
        }
        var client_currency = parseInt(response.client_currency);
        if (client_currency != 0) {
            customer_currency = client_currency;
            do_billable_checkbox();
        } else {
            customer_currency = '';
            set_base_currency();
        }
    }, 'json');
}

function expenseSubmitHandler(form) {

    selectCurrency.prop('disabled', false);

    $('select[name="tax2"]').prop('disabled', false);
    $('input[name="billable"]').prop('disabled', false);
    $('input[name="date"]').prop('disabled', false);

    $.post(form.action, $(form).serialize()).done(function(response) {
        response = JSON.parse(response);
        if (response.expenseid) {
            if (typeof(expenseDropzone) !== 'undefined') {
                if (expenseDropzone.getQueuedFiles().length > 0) {
                    expenseDropzone.options.url = admin_url + 'expenses/add_expense_attachment/' + response
                        .expenseid;
                    expenseDropzone.processQueue();
                } else {
                    window.location.assign(response.url);
                }
            } else {
                window.location.assign(response.url);
            }
        } else {
            window.location.assign(response.url);
        }
    });
    return false;
}

function do_billable_checkbox() {
    var val = $('select[name="clientid"]').val();
    if (val != '') {
        $('.billable').removeClass('hide');
        if ($('input[name="billable"]').prop('checked') == true) {
            if ($('#repeat_every').selectpicker('val') != '') {
                $('.billable_recurring_options').removeClass('hide');
            } else {
                $('.billable_recurring_options').addClass('hide');
            }
            if (customer_currency != '') {
                selectCurrency.val(customer_currency);
                selectCurrency.selectpicker('refresh');
            } else {
                set_base_currency();
            }
        } else {
            $('.billable_recurring_options').addClass('hide');
            // When project is selected, the project currency will be used, either customer currency or base currency
            if ($('#project_id').selectpicker('val') == '') {
                set_base_currency();
            }
        }
    } else {
        set_base_currency();
        $('.billable').addClass('hide');
        $('.billable_recurring_options').addClass('hide');
    }
}

function set_base_currency() {
    selectCurrency.val(selectCurrency.data('base'));
    selectCurrency.selectpicker('refresh');
}
</script>
</body>

</html>
