<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <?php
            $rel_id = '';
            if (isset($document)) {
                echo form_hidden('is_edit', 'true'); 
			} 
             ?>
            <?php echo form_open_multipart($this->uri->uri_string(), ['id' => 'document-form', 'class' => 'dropzone dropzone-manual']) ; ?>
            <div class="col-md-6">
                <h4 class="tw-mt-0 tw-font-semibold tw-text-lg tw-text-neutral-700">
                    <?php echo $title; ?>
                </h4>
                <div class="panel_s">
                    <div class="panel-body"> 
                        <?php
                     if (isset($document) && $document->recurring_from != null) {
                         $recurring_document = $this->documents_model->get($document->recurring_from);
                         echo '<div class="col-md-12"> <div class="alert alert-info">' . _l('document_recurring_from', '<a href="' . admin_url('documents/list_documents/' . $document->recurring_from) . '" target="_blank">' . $recurring_document->category_name . (!empty($recurring_document->document_name) ? ' (' . $recurring_document->document_name . ')' : '') . '</a></div></div>');
                     }
                     ?> 
					 <div class="col-md-12"> 
                        <div class="form-group select-placeholder">
                            <label for="clientid"
                                class="control-label"><?php echo _l('document_add_edit_customer'); ?></label>
                            <select id="clientid" name="clientid" data-live-search="true" data-width="100%"
                                class="ajax-search"
                                data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                <?php 
								if (isset($document)) {
									$selected = $document->clientid ;
								} else if (isset($_GET['clientid'])) {	 
									$selected = $_GET['clientid'] ;
								} else if (isset($customer_id)) {
									$selected = $customer_id ;
								} else {
									$selected = '';
								} 
                        if ($selected != '') {
                            $rel_data = get_relation_data('customer', $selected);
                            $rel_val  = get_relation_values($rel_data, 'customer');
                            echo '<option value="' . $rel_val['id'] . '" selected>' . $rel_val['name'] . '</option>';
                        } ?>
                            </select>
							<table id="project_ajax_search_tableau" class="hide fade in table table-responsive table-stripped" style="width: 100%;margin:10px 0 -20px 0;background: #fbf2ea;"> <thead id="project_ajax_search_tableau_demandes"></thead></table>  
                        </div>
                        <hr class="hr-panel-separator" />
					</div>
					
					<div class="col-md-12"> 	
                        
					</div>
					 
					 <div class="col-md-6"> 
							<?php $value = (isset($document) ? _d($document->date) : _d(date('Y-m-d')));
						 $date_attrs     = [];
						 if (isset($document) && $document->recurring > 0 && $document->last_recurring_date != null) {
							 $date_attrs['disabled'] = true;
						 }
						 ?>
                        <?php echo render_date_input('date', 'document_add_edit_date', $value, $date_attrs);
						$value = (isset($document) ? $document->amount : ''); ?>
					 </div>
					 
					 
					 <div class="col-md-6">
						   <?php echo render_input('amount', 'Montant (HT)', $value, 'number');
						 $hide_billable_options = 'hide';

						 if ((isset($document) && ($document->billable == 1 || $document->clientid != 0)) || isset($customer_id)) {
							 $hide_billable_options = '';
						 }
						 ?> 
					 </div>
					 
					 <div class="col-md-3  ">
					 
						<label for="billable" class="control-label" <?php if (isset($document) && $document->invoiceid !== null) {
                         echo 'data-toggle="tooltip" title="' . _l('document_already_invoiced') . '"';
                     } ?>><?php echo _l('document_add_edit_billable'); ?> ?</label>
                        <div class="checkbox checkbox-primary billable <?php echo $hide_billable_options; ?>">
                            <input type="checkbox" id="billable" <?php if (isset($document) && $document->invoiceid !== null) {
                         echo 'disabled';
                     } ?> name="billable" <?php if (isset($document)) {
                         if ($document->billable == 1) {
                             echo 'checked';
                         }
                     }; ?>>
                            <label for="billable" <?php if (isset($document) && $document->invoiceid !== null) {
                         echo 'data-toggle="tooltip" title="' . _l('document_already_invoiced') . '"';
                     } ?>></label>
                        </div>
					 </div>

					 <div class="col-md-12"> 
                        <?php hooks()->do_action('before_document_form_name', isset($document) ? $document : null); ?>

                        <i class="fa-regular fa-circle-question pull-left tw-mt-0.5 tw-mr-1" data-toggle="tooltip"
                            data-title="<?php echo _l('document_name_help'); ?> - <?php echo _l('document_field_billable_help', _l('document_name')); ?>"></i>
                        <?php $value = (isset($document) ? $document->document_name : ''); ?>
                        <?php echo render_input('document_name', 'document_name', $value); ?>
					</div>	
					  
						
                        <?php $hide_project_selector = ' hide';
                     // Show selector only if document is already added and there is no client linked to the document or isset customer id
                     if ((isset($document) && $document->clientid != 0) || isset($customer_id)) {
                         $hide_project_selector = '';
                     }
                     ?>
                        <div class="hide form-group projects-wrapper<?php echo $hide_project_selector; ?>">
                            <label for="project_id"><?php echo _l('project'); ?></label>
                            <div id="project_ajax_search_wrapper">
                                <select name="project_id" id="project_id" class="projects ajax-search"
                                    data-live-search="true" data-width="100%"
                                    data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                    <?php if (isset($document) && $document->project_id != 0) {
                         echo '<option value="' . $document->project_id . '" selected>' . get_project_name_by_id($document->project_id) . '</option>';
                     }
                           ?>
                                </select>
                            </div>
                        </div>
                        <div class="btn-bottom-toolbar text-right">
                            <button type="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <h4 class="tw-mt-0 tw-font-semibold tw-text-lg tw-text-neutral-700">
                    <?php echo _l('advanced_options'); ?>
                </h4>
                <div class="panel_s">
                    <div class="panel-body">

                        <?php if (isset($document) && $document->attachment !== '') { ?>
                        <div class="row">
                            <div class="col-md-10">
                                <i class="<?php echo get_mime_class($document->filetype); ?>"></i> <a
                                    href="<?php echo site_url('download/file/document/' . $document->documentid); ?>"><?php echo $document->attachment; ?></a>
                            </div>
                            <?php if ($document->attachment_added_from == get_staff_user_id() || is_admin()) { ?>
                            <div class="col-md-2 text-right">
                                <a href="<?php echo admin_url('documents/delete_document_attachment/' . $document->documentid); ?>"
                                    class="text-danger _delete"><i class="fa fa fa-times"></i></a>
                            </div>
                            <?php } ?>
                        </div>
                        <?php } ?>
                        <?php if (!isset($document) || (isset($document) && $document->attachment == '')) { ?>
                        <div id="dropzoneDragArea" class="dz-default dz-message">
                            <span><?php echo _l('document_add_edit_attach_receipt'); ?></span>
                        </div>
                        <div class="dropzone-previews"></div>
                        <?php } ?>
                        <hr class="hr-panel-separator" />
						
                        <i class="fa-regular fa-circle-question pull-left tw-mt-0.5 tw-mr-1" data-toggle="tooltip"
                            data-title="<?php echo _l('document_field_billable_help', _l('document_add_edit_note')); ?>"></i>
                        <?php $value = (isset($document) ? $document->note : ''); ?>
                        <?php echo render_textarea('note', 'document_add_edit_note', $value, ['rows' => 4], []); ?>
					 
                        <?php $rel_id = (isset($document) ? $document->documentid : false); ?>
                        <?php echo render_custom_fields('documents', $rel_id); ?>
						 
                        <div class=" hide">
                        <?php
							 $currency_attr = ['disabled' => true, 'data-show-subtext' => true];

							 $currency_attr = apply_filters_deprecated('document_currency_disabled', [$currency_attr], '2.3.0', 'document_currency_attributes');

							 foreach ($currencies as $currency) {
								 if ($currency['isdefault'] == 1) {
									 $currency_attr['data-base'] = $currency['id'];
								 }
								 if (isset($document)) {
									 if ($currency['id'] == $document->currency) {
										 $selected = $currency['id'];
									 }
									 if ($document->billable == 0) {
										 if ($document->clientid != 0) {
											 $c = $this->clients_model->get_customer_default_currency($document->clientid);
											 if ($c != 0) {
												 $customer_currency = $c;
											 }
										 }
									 }
								 } else {
									 if (isset($customer_id)) {
										 $c = $this->clients_model->get_customer_default_currency($customer_id);
										 if ($c != 0) {
											 $customer_currency = $c;
										 }
									 }
									 if ($currency['isdefault'] == 1) {
										 $selected = $currency['id'];
									 }
								 }
							 }
							 $currency_attr = hooks()->apply_filters('document_currency_attributes', $currency_attr);
						?>
                        </div>
                        <div id="document_currency" class=" hide">
                            <?php echo render_select('currency', $currencies, ['id', 'name', 'symbol'], 'document_currency', $selected, $currency_attr); ?>
                        </div>
                        <div class="row hide">
                            <div class="col-md-6 hide">
                                <div class="form-group select-placeholder">
                                    <label class="control-label" for="tax"><?php echo _l('tax_1'); ?></label>
                                    <select class="selectpicker display-block" data-width="100%" name="tax"
                                        data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                        <option value=""><?php echo _l('no_tax'); ?></option>
                                        <?php foreach ($taxes as $tax) {
												 $selected = '';
												 if (isset($document)) {
													 if ($tax['id'] == $document->tax) {
														 $selected = 'selected';
													 }
												 } ?>
											<option value="<?php echo $tax['id']; ?>" <?php echo $selected; ?>
												data-percent="<?php echo $tax['taxrate']; ?>"
												data-subtext="<?php echo $tax['name']; ?>">
												<?php echo $tax['taxrate']; ?>%
											</option>
                                        <?php } ?>
                                    </select>

                                </div>
                            </div>
                            <div class="col-md-6 hide">
                                <div class="form-group select-placeholder">
                                    <label class="control-label" for="tax2"><?php echo _l('tax_2'); ?></label>
                                    <select class="selectpicker display-block" data-width="100%" name="tax2"
                                        data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>" <?php if (!isset($document) || isset($document) && $document->tax == 0) {
											 echo 'disabled';
										 } ?>>
                                        <option value=""><?php echo _l('no_tax'); ?></option>
                                        <?php foreach ($taxes as $tax) {
											 $selected = '';
											 if (isset($document)) {
												 if ($tax['id'] == $document->tax2) {
													 $selected = 'selected';
												 }
											 } ?>
											<option value="<?php echo $tax['id']; ?>" <?php echo $selected; ?>
												data-percent="<?php echo $tax['taxrate']; ?>"
												data-subtext="<?php echo $tax['name']; ?>">
												<?php echo $tax['taxrate']; ?>%
											</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <?php if (!isset($document)) { ?>
                            <div class="col-md-12 hide" id="tax_subtract">
                                <div class="alert alert-info">
                                    <div class="checkbox checkbox-primary no-margin">
                                        <input type="checkbox" id="tax1_included">
                                        <label for="tax1_included">
                                            <?php echo _l('subtract_tax_total_from_amount', '<span id="tax_subtract_total" class="bold"></span>'); ?>
                                        </label>
                                    </div>
                                    <p class="tw-text-sm tw-mt-2 tw-ml-7">
                                        <?php echo _l('document_subtract_info_text'); ?>
                                    </p>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                        <div class="clearfix mtop15 hide"></div>
                        <div class="row hide">
                            <div class="col-md-6">
                                <?php $selected = (isset($document) ? $document->paymentmode : ''); ?>
                                <?php echo render_select('paymentmode', $payment_modes, ['id', 'name'], 'payment_mode', $selected); ?>
                            </div>
                            <div class="col-md-6 hide">
                                <?php $value = (isset($document) ? $document->reference_no : ''); ?>
                                <?php echo render_input('reference_no', 'document_add_edit_reference_no', $value); ?>
                            </div>
                        </div>
                        <div class="form-group select-placeholder hide"
                            <?php if (isset($document) && !empty($document->recurring_from)) { ?> data-toggle="tooltip"
                            data-title="<?php echo _l('create_recurring_from_child_error_message', [_l('document_lowercase'), _l('document_lowercase'), _l('document_lowercase')]); ?>"
                            <?php } ?>>
                            <label for="repeat_every"
                                class="control-label"><?php echo _l('document_repeat_every'); ?></label>
                            <select name="repeat_every" id="repeat_every" class="selectpicker" data-width="100%"
                                data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>"
                                <?php if (isset($document) && !empty($document->recurring_from)) { ?> disabled <?php } ?>>
                                <option value=""></option>
                                <option value="1-week" <?php if (isset($document) && $document->repeat_every == 1 && $document->recurring_type == 'week') {
									 echo 'selected';
								 } ?>><?php echo _l('week'); ?></option>
											<option value="2-week" <?php if (isset($document) && $document->repeat_every == 2 && $document->recurring_type == 'week') {
									 echo 'selected';
								 } ?>>2 <?php echo _l('weeks'); ?></option>
											<option value="1-month" <?php if (isset($document) && $document->repeat_every == 1 && $document->recurring_type == 'month') {
									 echo 'selected';
								 } ?>>1 <?php echo _l('month'); ?></option>
											<option value="2-month" <?php if (isset($document) && $document->repeat_every == 2 && $document->recurring_type == 'month') {
									 echo 'selected';
								 } ?>>2 <?php echo _l('months'); ?></option>
											<option value="3-month" <?php if (isset($document) && $document->repeat_every == 3 && $document->recurring_type == 'month') {
									 echo 'selected';
								 } ?>>3 <?php echo _l('months'); ?></option>
											<option value="6-month" <?php if (isset($document) && $document->repeat_every == 6 && $document->recurring_type == 'month') {
									 echo 'selected';
								 } ?>>6 <?php echo _l('months'); ?></option>
											<option value="1-year" <?php if (isset($document) && $document->repeat_every == 1 && $document->recurring_type == 'year') {
									 echo 'selected';
								 } ?>>1 <?php echo _l('year'); ?></option>
											<option value="custom" <?php if (isset($document) && $document->custom_recurring == 1) {
									 echo 'selected';
								 } ?>><?php echo _l('recurring_custom'); ?></option>
                            </select>
                        </div>
                        <div class="recurring_custom <?php if ((isset($document) && $document->custom_recurring != 1) || (!isset($document))) {
                         echo 'hide';
                     } ?>">
                            <div class="row hide">
                                <div class="col-md-6">
                                    <?php $value = (isset($document) && $document->custom_recurring == 1 ? $document->repeat_every : 1); ?>
                                    <?php echo render_input('repeat_every_custom', '', $value, 'number', ['min' => 1]); ?>
                                </div>
                                <div class="col-md-6">
                                    <select name="repeat_type_custom" id="repeat_type_custom" class="selectpicker"
                                        data-width="100%"
                                        data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                        <option value="day" <?php if (isset($document) && $document->custom_recurring == 1 && $document->recurring_type == 'day') {
											 echo 'selected';
										 } ?>><?php echo _l('document_recurring_days'); ?></option>
															<option value="week" <?php if (isset($document) && $document->custom_recurring == 1 && $document->recurring_type == 'week') {
											 echo 'selected';
										 } ?>><?php echo _l('document_recurring_weeks'); ?></option>
															<option value="month" <?php if (isset($document) && $document->custom_recurring == 1 && $document->recurring_type == 'month') {
											 echo 'selected';
										 } ?>><?php echo _l('document_recurring_months'); ?></option>
															<option value="year" <?php if (isset($document) && $document->custom_recurring == 1 && $document->recurring_type == 'year') {
											 echo 'selected';
										 } ?>><?php echo _l('document_recurring_years'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div id="cycles_wrapper" class="<?php if (!isset($document) || (isset($document) && $document->recurring == 0)) {
                         echo ' hide';
                     }?>">
                            <?php $value = (isset($document) ? $document->cycles : 0); ?>
                            <div class="form-group recurring-cycles">
                                <label for="cycles"><?php echo _l('recurring_total_cycles'); ?>
                                    <?php if (isset($document) && $document->total_cycles > 0) {
                         echo '<small>' . _l('cycles_passed', $document->total_cycles) . '</small>';
                     }
                           ?>
                                </label>
                                <div class="input-group">
                                    <input type="number" class="form-control" <?php if ($value == 0) {
                               echo ' disabled';
                           } ?> name="cycles" id="cycles" value="<?php echo $value; ?>" <?php if (isset($document) && $document->total_cycles > 0) {
                               echo 'min="' . ($document->total_cycles) . '"';
                           } ?>>
                                    <div class="input-group-addon">
                                        <div class="checkbox">
                                            <input type="checkbox" <?php if ($value == 0) {
                               echo ' checked';
                           } ?> id="unlimited_cycles">
                                            <label for="unlimited_cycles"><?php echo _l('cycles_infinity'); ?></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="hide">
                            <?php
                        $hide_invoice_recurring_options = 'hide';
                        if (isset($document) && $document->billable == 1) {
                            $hide_invoice_recurring_options = '';
                        }
                        ?>
                            <div
                                class="checkbox checkbox-primary billable_recurring_options <?php echo $hide_invoice_recurring_options; ?>">
                                <input type="checkbox" id="create_invoice_billable" name="create_invoice_billable" <?php if (isset($document)) {
                            if ($document->create_invoice_billable == 1) {
                                echo 'checked';
                            }
                        }; ?>>
                                <label for="create_invoice_billable"><i class="fa-regular fa-circle-question"
                                        data-toggle="tooltip"
                                        title="<?php echo _l('document_recurring_autocreate_invoice_tooltip'); ?>"></i>
                                    <?php echo _l('document_recurring_auto_create_invoice'); ?></label>
                            </div>
                        </div>
                        <div
                            class="hide checkbox checkbox-primary billable_recurring_options <?php echo $hide_invoice_recurring_options; ?>">
                            <input type="checkbox" name="send_invoice_to_customer" id="send_invoice_to_customer" <?php if (isset($document)) {
                            if ($document->send_invoice_to_customer == 1) {
                                echo 'checked';
                            }
                        }; ?>>
                            <label
                                for="send_invoice_to_customer"><?php echo _l('document_recurring_send_custom_on_renew'); ?></label>
                        </div>
                    </div>
                </div>
            </div>
            <?php hooks()->do_action('before_document_form_template_close', $document ?? null); ?>
            <?php echo form_close(); ?>
        </div>
        <div class="btn-bottom-pusher"></div>
    </div>
</div>
<?php $this->load->view('admin/documents/document_category'); ?>
<?php init_tail(); ?>
<script>
var customer_currency = '';
Dropzone.options.documentForm = false;
var documentDropzone;
init_ajax_project_search_by_customer_id();
var selectCurrency = $('select[name="currency"]');
<?php if (isset($customer_currency)) { ?>
var customer_currency = '<?php echo $customer_currency; ?>';
<?php } ?>
$(function() {
    $('body').on('change', '#project_id', function() {
        var project_id = $(this).val();
        if (project_id != '') {
            if (customer_currency != 0) {
                selectCurrency.val(customer_currency);
                selectCurrency.selectpicker('refresh');
            } else {
                set_base_currency();
            }
        } else {
            do_billable_checkbox();
        }
    });
	
	
    $('body').on('change', '#clientid', function() {
		var idclient = $(this).val();
        if (idclient != '') {
			 console.log("clientid 458");
			document_clientid_select(idclient);
			voir_contrats_par_beneficiaire(idclient);
        }
    });
	
	<?php if (isset($_GET['clientid'])) { ?>
		var idclient = <?php echo $_GET['clientid']; ?>;
        if (idclient != '') {
			$('#clientid').trigger("change");
			 console.log("clientid change 466");
			document_clientid_select(idclient);
			voir_contrats_par_beneficiaire(idclient);
        }
	
	<?php } ?>
	 

    if ($('#dropzoneDragArea').length > 0) {
        documentDropzone = new Dropzone("#document-form", appCreateDropzoneOptions({
            autoProcessQueue: false,
            clickable: '#dropzoneDragArea',
            previewsContainer: '.dropzone-previews',
            addRemoveLinks: true,
            maxFiles: 1,
            success: function(file, response) {
                response = JSON.parse(response);
                if (this.getUploadingFiles().length === 0 && this.getQueuedFiles().length ===
                    0) {
                    window.location.assign(response.url);
                }
            },
        }));
    }

    appValidateForm($('#document-form'), {
        category: 'required',
        date: 'required',
        amount: 'required',
        currency: 'required',
        repeat_every_custom: {
            min: 1
        },
    }, documentSubmitHandler);

    $('input[name="billable"]').on('change', function() {
        do_billable_checkbox();
    });

    $('#repeat_every').on('change', function() {
        if ($(this).selectpicker('val') != '' && $('input[name="billable"]').prop('checked') == true) {
            $('.billable_recurring_options').removeClass('hide');
        } else {
            $('.billable_recurring_options').addClass('hide');
        }
    });

    // hide invoice recurring options on page load
    $('#repeat_every').trigger('change');

    $('select[name="clientid"]').on('change', function() {
        customer_init();
        do_billable_checkbox(); 
		var clientid = $('select[name="clientid"]').val();
		voir_contrats_par_beneficiaire(clientid);
		//console.log("clientid"+clientid);
        $('input[name="billable"]').trigger('change');
    });

    <?php if (!isset($document)) { ?>
    $('select[name="tax"], select[name="tax2"]').on('change', function() {

        delay(function() {
            var $amount = $('#amount'),
                taxDropdown1 = $('select[name="tax"]'),
                taxDropdown2 = $('select[name="tax2"]'),
                taxPercent1 = parseFloat(taxDropdown1.find('option[value="' + taxDropdown1
                    .val() + '"]').attr('data-percent')),
                taxPercent2 = parseFloat(taxDropdown2.find('option[value="' + taxDropdown2
                    .val() + '"]').attr('data-percent')),
                total = $amount.val();

            if (total == 0 || total == '') {
                return;
            }

            if ($amount.attr('data-original-amount')) {
                total = $amount.attr('data-original-amount');
            }

            total = parseFloat(total);

            if (taxDropdown1.val() || taxDropdown2.val()) {

                $('#tax_subtract').removeClass('hide');

                var totalTaxPercentExclude = taxPercent1;
                if (taxDropdown2.val()) {
                    totalTaxPercentExclude += taxPercent2;
                }

                var totalExclude = accounting.toFixed(total - exclude_tax_from_amount(
                    totalTaxPercentExclude, total), app.options.decimal_places);
                $('#tax_subtract_total').html(accounting.toFixed(totalExclude, app.options
                    .decimal_places));
            } else {
                $('#tax_subtract').addClass('hide');
            }
            if ($('#tax1_included').prop('checked') == true) {
                subtract_tax_amount_from_document_total();
            }
        }, 200);
    });

    $('#amount').on('blur', function() {
        $(this).removeAttr('data-original-amount');
        if ($(this).val() == '' || $(this).val() == '') {
            $('#tax1_included').prop('checked', false);
            $('#tax_subtract').addClass('hide');
        } else {
            var tax1 = $('select[name="tax"]').val();
            var tax2 = $('select[name="tax2"]').val();
            if (tax1 || tax2) {
                setTimeout(function() {
                    $('select[name="tax2"]').trigger('change');
                }, 100);
            }
        }
    })

    $('#tax1_included').on('change', function() {

        var $amount = $('#amount'),
            total = parseFloat($amount.val());

        // da pokazuva total za 2 taxes  Subtract TAX total (136.36) from document amount
        if (total == 0) {
            return;
        }

        if ($(this).prop('checked') == false) {
            $amount.val($amount.attr('data-original-amount'));
            return;
        }

        subtract_tax_amount_from_document_total();
    });
    <?php } ?>
});


function document_clientid_select(clientid) {
    var serverData = {}; 
    init_ajax_search(clientid, serverData);
}

function voir_contrats_par_beneficiaire(idclient) {
	//console.log("435");
	$.get(admin_url + 'documents/get_user_proposals/' + idclient + '/0',
		function(response) {
			$('#project_ajax_search_tableau').addClass('hide'); 
			$('#project_ajax_search_tableau_demandes').html('');   					
			if (!$.trim(response)){   
				$('#project_ajax_search_tableau_demandes').append(' <tr><td colspan="2"><p class="bold text-danger text-center" >Aucun contrat créé pour ce bénéficiaire <a href="/admin/clients/client/'+ idclient +'" target="_blank" class="btn btn_layout_light small" >consulter</a></p></td> </tr>'); 
				$('#note').html(''); 
			} else {   
			 console.log(response); 
				//<a href="/admin/proposals#'+response.id+'?tab=settings" target="_blank" class="btn btn_layout_light small" >Contrat #'+response.id+'</a>
				
				var pj_customer = "";
				var pj_tickets = "";
				var pj_proposals = "";
				
				if ($.trim(response.attachments_customer)){ 
					var pjcustomer = response.attachments_customer[0];
					$.each(pjcustomer, function(index,value){
						//console.log( index + " : " + pjcustomer.file_name + "(status : "+ pjcustomer.filetype +") ");
						pj_customer = '<tr><td colspan="2"><a href="/download/file/client/'+pjcustomer.attachment_key+'" target="_blank" class="btn btn_layout_light small" >'+pjcustomer.file_name+'</a></td></tr>'; 
					});
				}
				if ($.trim(response.attachments_tickets)){ 
					var pjtickets = response.attachments_tickets[0];
						//pj_tickets = '<tr><td colspan="2">PJ Demandes de subvention :</td></tr>'; 
					$.each(pjtickets, function(index,value){
						// console.log("615"+ pjtickets);
						// console.log( index + " : " + pjtickets.file_name + "(status : "+ pjtickets.filetype +") ");
						pj_tickets = '<tr><td colspan="2"><a href="/download/file/ticket/'+pjtickets.id+'/" target="_blank" class="btn btn_layout_light small" >'+pjtickets.file_name+'</a></td></tr>'; 
						
						//<iframe src="/uploads/ticket_attachments/'+pjtickets.ticketid+'/'+pjtickets.file_name+'" height="200" width="300"></iframe>
					});
				}
				if ($.trim(response.attachments_proposals)){ 
					var pjproposals = response.attachments_proposals[0];
					$.each(pjproposals, function(index,value){
						//console.log( index + " : " + pjproposals.file_name + "(status : "+ pjproposals.filetype +") ");
						pj_proposals = '<tr><td colspan="2"><a href="/download/file/proposal/'+attachment_key+'" target="_blank" class="btn btn_layout_light small" >'+pjproposals.file_name+'</a></td></tr>'; 
					});
				}
			
				$('#project_ajax_search_tableau_demandes').append(' <tr><td style="max-width:100px;text-align:center"><a href="/proposal/'+response.id+'/'+response.hash+'" target="_blank" class="btn btn_layout_light small" >Contrat #'+response.id+'</a><br />'+response.statut+'</td><td>'+response.description+'<hr /><small>Subvention accordée : '+response.montant+'€ HT</small></td></tr><tr class="hide"><td colspan="2">Fichier(s)</td></tr>'+pj_tickets+''+pj_proposals+''+pj_customer+''); 
				
				 
				
				$('#note').html('Contrat #'+response.id+''
				+ response.description.replace(/<\/?[^>]+(>|$)/g, "") +' '); 
				//$.each(response, function(index,value){
				//	console.log( index + " : " + response.total + "(status : "+ response.status +") "); 
				//});  
			} 
				$('#project_ajax_search_tableau').removeClass('hide');  
		}, 'json'); 
				  
}

function subtract_tax_amount_from_document_total() {
    var $amount = $('#amount'),
        total = parseFloat($amount.val()),
        taxDropdown1 = $('select[name="tax"]'),
        taxDropdown2 = $('select[name="tax2"]'),
        taxRate1 = parseFloat(taxDropdown1.find('option[value="' + taxDropdown1.val() + '"]').attr('data-percent')),
        taxRate2 = parseFloat(taxDropdown2.find('option[value="' + taxDropdown2.val() + '"]').attr('data-percent'));

    var totalTaxPercentExclude = taxRate1;
    if (taxRate2) {
        totalTaxPercentExclude += taxRate2;
    }

    if ($amount.attr('data-original-amount')) {
        total = parseFloat($amount.attr('data-original-amount'));
    }

    $amount.val(exclude_tax_from_amount(totalTaxPercentExclude, total));

    if ($amount.attr('data-original-amount') == undefined) {
        $amount.attr('data-original-amount', total);
    }
}

function customer_init() {
    var customer_id = $('select[name="clientid"]').val();
    var projectAjax = $('select[name="project_id"]');
    var clonedProjectsAjaxSearchSelect = projectAjax.html('').clone();
    var projectsWrapper = $('.projects-wrapper');
    projectAjax.selectpicker('destroy').remove();
    projectAjax = clonedProjectsAjaxSearchSelect;
    $('#project_ajax_search_wrapper').append(clonedProjectsAjaxSearchSelect);
    init_ajax_project_search_by_customer_id();
    if (!customer_id) {
        set_base_currency();
        projectsWrapper.addClass('hide');
    }
    $.get(admin_url + 'documents/get_customer_change_data/' + customer_id, function(response) {
        if (customer_id && response.customer_has_projects) {
            projectsWrapper.removeClass('hide');
        } else {
            projectsWrapper.addClass('hide');
        }
        var client_currency = parseInt(response.client_currency);
        if (client_currency != 0) {
            customer_currency = client_currency;
            do_billable_checkbox();
        } else {
            customer_currency = '';
            set_base_currency();
        }
    }, 'json');
}

function documentSubmitHandler(form) {

    selectCurrency.prop('disabled', false);

    $('select[name="tax2"]').prop('disabled', false);
    $('input[name="billable"]').prop('disabled', false);
    $('input[name="date"]').prop('disabled', false);

    $.post(form.action, $(form).serialize()).done(function(response) {
        response = JSON.parse(response);
        if (response.documentid) {
            if (typeof(documentDropzone) !== 'undefined') {
                if (documentDropzone.getQueuedFiles().length > 0) {
                    documentDropzone.options.url = admin_url + 'documents/add_document_attachment/' + response
                        .documentid;
                    documentDropzone.processQueue();
                } else {
                    window.location.assign(response.url);
                }
            } else {
                window.location.assign(response.url);
            }
        } else {
            window.location.assign(response.url);
        }
    });
    return false;
}

function do_billable_checkbox() {
    var val = $('select[name="clientid"]').val();
    if (val != '') {
        $('.billable').removeClass('hide');
        if ($('input[name="billable"]').prop('checked') == true) {
            if ($('#repeat_every').selectpicker('val') != '') {
                $('.billable_recurring_options').removeClass('hide');
            } else {
                $('.billable_recurring_options').addClass('hide');
            }
            if (customer_currency != '') {
                selectCurrency.val(customer_currency);
                selectCurrency.selectpicker('refresh');
            } else {
                set_base_currency();
            }
        } else {
            $('.billable_recurring_options').addClass('hide');
            // When project is selected, the project currency will be used, either customer currency or base currency
            if ($('#project_id').selectpicker('val') == '') {
                set_base_currency();
            }
        }
    } else {
        set_base_currency();
        $('.billable').addClass('hide');
        $('.billable_recurring_options').addClass('hide');
    }
}

function set_base_currency() {
    selectCurrency.val(selectCurrency.data('base'));
    selectCurrency.selectpicker('refresh');
}
</script>
</body>

</html>
