<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="customer_document_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button group="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">
                    <span class="edit-title">Modification</span>
                    <span class="add-title">Ajout</span>
                </h4>
            </div>
            <?php echo form_open('admin/documents/manage_documents', ['id' => 'customer-document-modal']); ?>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
						<select class="selectpicker display-block" data-width="100%" name="file_cat" data-none-selected-text="Choisir">
							<option value=""></option>
							<?php foreach ($attachments_cats as $attachments_cat) { ?>
							<option value="<?php echo $attachments_cat['attachment_cat_id']; ?>" data-subtext="<?php echo $attachments_cat['attachment_cat_name']; ?>"><?php echo $attachments_cat['attachment_cat_name']; ?></option>
							<?php } ?>
						</select>
					<?php /* ?>
						<?php echo render_input('file_cat', 'customer_group_name'); ?> <?php */ ?>
                        <?php echo form_hidden('id'); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button group="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button group="submit" class="btn btn-primary"><?php echo _l('submit'); ?></button>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<script>
    window.addEventListener('load',function(){
       appValidateForm($('#customer-document-modal'), {
        file_cat: 'required'
    }, manage_customer_documents);

       $('#customer_document_modal').on('show.bs.modal', function(e) {
        var invoker = $(e.relatedTarget);
        var document_id = $(invoker).data('id');
        $('#customer_document_modal .add-title').removeClass('hide');
        $('#customer_document_modal .edit-title').addClass('hide');
        $('#customer_document_modal input[name="id"]').val('');
        $('#customer_document_modal input[name="file_cat"]').val('');
        // is from the edit button
        if (typeof(document_id) !== 'undefined') {
            $('#customer_document_modal input[name="id"]').val(document_id);
            $('#customer_document_modal .add-title').addClass('hide');
            $('#customer_document_modal .edit-title').removeClass('hide');
            $('#customer_document_modal input[name="file_cat"]').val($(invoker).parents('tr').find('td').eq(0).text());
        }
    });
   });
    function manage_customer_documents(form) {
        var data = $(form).serialize();
        var url = form.action;
        $.post(url, data).done(function(response) {
            response = JSON.parse(response);
            if (response.success == true) {
                if($.fn.DataTable.isDataTable('.table-documents')){
                    $('.table-documents').DataTable().ajax.reload();
                }
                if($('body').hasClass('dynamic-create-documents') && typeof(response.id) != 'undefined') {
                    var documents = $('select[name="documents_in[]"]');
                    documents.prepend('<option value="'+response.id+'">'+response.name+'</option>');
                    documents.selectpicker('refresh');
                }
                alert_float('success', response.message);
            }
            $('#customer_document_modal').modal('hide');
        });
        return false;
    }

</script>