<?php defined('BASEPATH') or exit('No direct script access allowed');
if (isset($client)) { ?>
<?php if (has_permission('customers', '', 'edit')) { ?>
<h4>Géolocalisation</h4>
<p>Cliquez sur "<i id="gmaps-search-icon" class="fa-brands fa-google" aria-hidden="true" style="color: #2563eb;"></i>" pour géolocaliser l'adresse du Bénéficiaire, puis déplacez le curseur sur la carte pour ajuster son emplacement.</p>
<div class="row" data-address="<?php echo htmlentities($client->address); ?>" data-city="<?php echo htmlentities($client->city); ?>" data-country="<?php echo htmlentities(get_country_name($client->country)); ?>" id="long_lat_wrapper">
    <div class="col-md-4">
      <div class="form-group">
          <label for="website"><?php echo _l('customer_latitude'); ?></label>
          <div class="input-group">
           <input type="text" name="latitude" id="latitude" value="<?php echo $client->latitude; ?>" class="form-control">
           <div class="input-group-addon">
            <span><a href="#" tabindex="-1" class="pull-left mright5" onclick="fetch_lat_long_from_google_cprofile(); return false;" data-toggle="tooltip" data-title="<?php echo _l('fetch_from_google') . ' - ' . _l('customer_fetch_lat_lng_usage'); ?>"><i id="gmaps-search-icon" class="fa-brands fa-google" aria-hidden="true"></i></a></span>
        </div>
    </div>
</div>
</div>
<div class="col-md-4">
    <?php echo render_input('longitude', 'customer_longitude', $client->longitude); ?>
</div>
<div class="col-md-4">
</div>
</div>
    <?php if (!empty($client->latitude) && !empty($client->longitude)) { ?>
        <a class="btn btn-default label-margin" target="_blank" href="<?php echo 'https://www.google.com/maps/search/?api=1&query=' . urlencode($client->latitude . ', ' . $client->longitude); ?>"><?php echo _l('open_google_map'); ?></a>
    <?php } ?>
<button class="btn btn-primary label-margin" onclick="save_longitude_and_latitude(<?php echo $client->userid; ?>); return false;"><?php echo _l('submit'); ?></button>
<hr />
<?php } ?>
<?php
if (get_option('google_api_key') !== '') {
    if ($client->longitude == '' && $client->latitude == '') {
        echo _l('customer_map_notice');
    } else {
        echo '<div id="map" class="customer_map"></div>';
    }
} else {
    echo _l('setup_google_api_key_customer_map');
}
}
?>
<script>
/* 2023-03-07 DRAGGABLE MARKER map.min.js
var marker;function initMap(){var styles=[{"featureType":"administrative","elementType":"labels.text.fill","stylers":[{"color":"#444444"}]},{"featureType":"landscape","elementType":"all","stylers":[{"color":"#f2f2f2"}]},{"featureType":"poi","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"road","elementType":"all","stylers":[{"saturation":-100},{"lightness":45}]},{"featureType":"road.highway","elementType":"all","stylers":[{"visibility":"simplified"}]},{"featureType":"road.arterial","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"transit","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"water","elementType":"all","stylers":[{"color":"#03a9f4"},{"visibility":"on"}]}];var latitude=$('#google-maps-api-js').attr('latitude');var longitude=$('#google-maps-api-js').attr('longitude');var mapMarkerTitle=$('#google-maps-api-js').attr('mapMarkerTitle');if(latitude==''||longitude==''){return}else if(isNaN(latitude)||isNaN(longitude)){return}
latLng=new google.maps.LatLng(latitude,longitude);var mapSelector=document.getElementById('map');if(mapSelector){map=new google.maps.Map(mapSelector,{center:{lat:parseFloat(latitude),lng:parseFloat(longitude)},zoom:12,styles:styles});var infowindow=new google.maps.InfoWindow({content:mapMarkerTitle});marker=new google.maps.Marker({position:latLng,title:mapMarkerTitle,visible:!0,draggable:!0});marker.addListener('click',function(){infowindow.open(map,marker)});google.maps.event.addListener(marker,'drag',function(event){$("#latitude").val(event.latLng.lat());$("#longitude").val(event.latLng.lng())});marker.setMap(map)}}
*/
</script>