<?php

use app\services\utilities\Arr;

defined('BASEPATH') or exit('No direct script access allowed');

class Documents_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Get expense(s)
     * @param  mixed $id Optional expense id
     * @return mixed     object or array
     */
    public function get($id = '', $where = [])
    {
		
		$this->db->select(db_prefix() . 'ticket_attachments.ticketid, '.db_prefix() . 'ticket_attachments.id, '.db_prefix() . 'ticket_attachments.file_name, '.db_prefix() . 'ticket_attachments.file_cat, '.db_prefix() . 'ticket_attachments.filetype');
        $this->db->join( db_prefix() . 'ticket_attachments', db_prefix() . 'tickets.ticketid = ' . db_prefix() . 'ticket_attachments.ticketid' , 'left');
		 
        $result = $this->db->get(db_prefix() . 'tickets');
        /* if (is_numeric($id)) {
            $document = $this->db->get()->row();
            if ($document) {
				
                $document->ticketid;
                $document->file_name;
                $document->file_cat;
                $document->filetype;
                $document->dateadded;

            }

            return $document;
        } */
 

        return $this->db->get()->result_array();
		
		 
       
/*
	   $this->db->select('*,' . db_prefix() . 'expenses.id as id,' . db_prefix() . 'expenses_categories.name as category_name,' . db_prefix() . 'payment_modes.name as payment_mode_name,' . db_prefix() . 'taxes.name as tax_name, ' . db_prefix() . 'taxes.taxrate as taxrate,' . db_prefix() . 'taxes_2.name as tax_name2, ' . db_prefix() . 'taxes_2.taxrate as taxrate2, ' . db_prefix() . 'expenses.id as expenseid,' . db_prefix() . 'expenses.addedfrom as addedfrom, recurring_from');
        $this->db->from(db_prefix() . 'expenses');
        $this->db->join(db_prefix() . 'clients', '' . db_prefix() . 'clients.userid = ' . db_prefix() . 'expenses.clientid', 'left');
        $this->db->join(db_prefix() . 'payment_modes', '' . db_prefix() . 'payment_modes.id = ' . db_prefix() . 'expenses.paymentmode', 'left');
        $this->db->join(db_prefix() . 'taxes', '' . db_prefix() . 'taxes.id = ' . db_prefix() . 'expenses.tax', 'left');
        $this->db->join('' . db_prefix() . 'taxes as ' . db_prefix() . 'taxes_2', '' . db_prefix() . 'taxes_2.id = ' . db_prefix() . 'expenses.tax2', 'left');
        $this->db->join(db_prefix() . 'expenses_categories', '' . db_prefix() . 'expenses_categories.id = ' . db_prefix() . 'expenses.category');
        $this->db->where($where);

        if (is_numeric($id)) {
            $this->db->where(db_prefix() . 'expenses.id', $id);
            $expense = $this->db->get()->row();
            if ($expense) {
                $expense->attachment            = '';
                $expense->filetype              = '';
                $expense->attachment_added_from = 0;

                $this->db->where('rel_id', $id);
                $this->db->where('rel_type', 'expense');
                $file = $this->db->get(db_prefix() . 'files')->row();

                if ($file) {
                    $expense->attachment            = $file->file_name;
                    $expense->filetype              = $file->filetype;
                    $expense->attachment_added_from = $file->staffid;
                }

                $this->load->model('projects_model');
                $expense->currency_data = get_currency($expense->currency);
                if ($expense->project_id != 0) {
                    $expense->project_data = $this->projects_model->get($expense->project_id);
                }

                if (is_null($expense->payment_mode_name)) {
                    // is online payment mode
                    $this->load->model('payment_modes_model');
                    $payment_gateways = $this->payment_modes_model->get_payment_gateways(true);
                    foreach ($payment_gateways as $gateway) {
                        if ($expense->paymentmode == $gateway['id']) {
                            $expense->payment_mode_name = $gateway['name'];
                        }
                    }
                }
            }

            return $expense;
        }
        $this->db->order_by('date', 'desc');

        return $this->db->get()->result_array();
*/
    }
	 
	
	    public function get_attachments_documents($document_id, $id = '')
    {
        // If is passed id get return only 1 attachment
        if (is_numeric($id)) {
            $this->db->where('id', $id);
        } else {
            $this->db->where('rel_id', $document_id);
        }
        $this->db->where('rel_type', 'document');
        $result = $this->db->get(db_prefix() . 'files');
        if (is_numeric($id)) {
            return $result->row();
        }

        return $result->result_array();
    }
	    public function get_attachments_tickets($rel_id)
    {
		$this->db->select(db_prefix() . 'tickets.ticketid, '.db_prefix() . 'ticket_attachments.id, '.db_prefix() . 'ticket_attachments.file_name, '.db_prefix() . 'ticket_attachments.filetype');
        $this->db->join( db_prefix() . 'ticket_attachments', db_prefix() . 'tickets.ticketid = ' . db_prefix() . 'ticket_attachments.ticketid' , 'left');
		 $this->db->where(db_prefix() . 'tickets.userid', $rel_id);
        //$this->db->where('rel_type', 'ticket_attachments');
        $result = $this->db->get(db_prefix() . 'tickets');
        if (is_numeric($id)) {
            return $result->row();
        }

        return $result->result_array();
    }
	    public function get_attachments_customer($document_id, $id = '')
    {
        // If is passed id get return only 1 attachment
        if (is_numeric($id)) {
            $this->db->where('id', $id);
        } else {
            $this->db->where('rel_id', $document_id);
        }
        $this->db->where('rel_type', 'customer');
        $result = $this->db->get(db_prefix() . 'files');
        if (is_numeric($id)) {
            return $result->row();
        }

        return $result->result_array();
    }
 

    public function get_expenses_years()
    {
        return $this->db->query('SELECT DISTINCT(YEAR(date)) as year FROM ' . db_prefix() . 'expenses ORDER by year DESC')->result_array();
    }
	
	
    public function get_attachments_cats()
    {
		 
        $this->db->order_by('attachment_cat_name', 'asc');

        return $this->db->get(db_prefix() . 'ticket_attachments_cats')->result_array();
    }
	
    public function get_lien_complet($id)
    { 
	
		$this->db->where('id', $id);
        $result = $this->db->get(db_prefix() . 'ticket_attachments'); 
		
        return $result->result_array();
	  
    }
	
/* 	
    public function add_attachments_cats($attachment_cat_id)
    {
        $this->db->insert(db_prefix() . 'ticket_attachments_cats', $data);
        log_activity('Catégorie de pièce jointe ajoutée [Nom : ' . $data['attachment_cat_name'] . ']');

        return $this->db->insert_id();
    }
    public function get_attachments_cat($itemid)
    {
		 
        $this->db->where('id', $itemid); 
        return $this->db->get(db_prefix() . 'ticket_attachments')->result_array();
    }


    public function edit_attachments_cat($attachment_cat_id, $itemid)
    {
        $this->db->where('id', $itemid);
        $this->db->update(db_prefix() . 'ticket_attachments.file_cat', $attachment_cat_id);
        if ($this->db->affected_rows() > 0) {
            log_activity('Pièce jointe '. $itemid .' mise à jour');

            return true;
        }

        return false;
    }

    public function delete_attachments_cat($id)
    {
        $this->db->where('attachment_cat_id', $id);
        $group = $this->db->get(db_prefix() . 'ticket_attachments_cats')->row();

        if ($group) {
            $this->db->where('attachment_cat_id', $id);
            $this->db->update(db_prefix() . 'ticket_attachments_cats', [
                'attachment_cat_id' => 0,
            ]);

            $this->db->where('attachment_cat_id', $id);
            $this->db->delete(db_prefix() . 'ticket_attachments_cats');

            log_activity('Catégorie de pièce jointe supprimée [Nom : ' . $group->attachment_cat_name . ']');

            return true;
        }

        return false;
    } */
 
    /**
     * Add new attachment groups
     * @param array $data $_POST data
     */
    public function add_attachment($data)
    {

        return false;
    }

    /**
     * Edit attachment group
     * @param  array $data $_POST data
     * @return boolean
     */
    public function edit_attachment($data)
    {
        $this->db->where('id', $data['id']);
        $this->db->update(db_prefix().'ticket_attachments', [
            'file_cat' => $data['file_cat'],
        ]);
        if ($this->db->affected_rows() > 0) {
            //log_activity('Màj catégorie PJ [ID:' . $data['id'] . '] [file_cat:' . $data['file_cat'] . ']');

            return true;
        }

        return false;
    }
	
	public function displayPdfFromUrl($url) {
		// Initialize cURL session
		$ch = curl_init();

		// Set cURL options
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Execute cURL request
		$data = curl_exec($ch);

		// Close cURL session
		curl_close($ch);

		// Return PDF file content
		return $data;
	}

	
	
}