<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Documents extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('documents_model');
    }

    public function index($id = '')
    { 

        $this->list_documents($id);
    }

    public function list_documents($id = '')
    {
        close_setup_menu();

        if (!has_permission('expenses', '', 'view') && !has_permission('expenses', '', 'view_own')) {
            access_denied('documents');
        }
        $this->load->model('documents_model');
		$data['attachments_cats'] 	= $this->documents_model->get_attachments_cats(); 
		 
        //$data['documentid']     = $id; 
        $data['title']         = _l('documents');

        $this->load->view('admin/documents/manage', $data);
    }

    public function table($clientid = '')
    {
        if (!has_permission('expenses', '', 'view') && !has_permission('expenses', '', 'view_own')) {
            ajax_access_denied();
        }
		
        //$this->load->model('payment_modes_model');
        //$data['payment_modes'] = $this->payment_modes_model->get('', [], true);

		$data['title']         = _l('documents');
		$this->app->get_table_data('documents', [
           // 'clientid' => $clientid,
            'data'     => $data,
        ]);
    }
	

    public function document($id = '')
    {
        $data['document'] = $this->documents_model->get($id);


        $title = _l('edit', _l('document'));


        $data['bodyclass']  = 'document';
        $data['title']      = $title;
        $this->load->view('admin/documents/document', $data);
    }
 

    /* Get item by id / ajax */
    public function get_item_by_id($id)
    {
        if ($this->input->is_ajax_request()) {
            $item 	= $this->documents_model->get_lien_complet($id);  
            //echo json_encode($item);
			
			$lien_telechargement = 'https://projets.ohelaterre.fr/download/preview_pdf?path=uploads/ticket_attachments/'.$item[0]['ticketid'].'/'.$item[0]['file_name'].'&type='.$item[0]['filetype'];
			
			$lien_complet = './uploads/ticket_attachments/'.$item[0]['ticketid'].'/'.$item[0]['file_name'];
			
		$pdfData = $this->documents_model->displayPdfFromUrl($lien_complet);
		$base64  = base64_encode(file_get_contents($lien_complet));
		$message = '<a href="'.$lien_telechargement.'" class="display-block mbot5"><iframe src="data:application/pdf;base64,'.$base64.'" width="100%" height="600" class="img-table-loading 3"></iframe></a>';
		//$message = '<a href="'.$lien_complet.'" class="display-block mbot5"><div class="table-image"><iframe src="'.$lien_complet.'" width="100%" height="500" class="img-table-loading"></iframe></div></a>';
		
			echo json_encode([  
				//'ticketid'      => $item[0]['ticketid'], 
				//'lien_complet'  => $lien_complet,
				'lien_telechargement'  => $lien_telechargement,
				'message'    	=> $message,
			]);
        } 
		 
    }


    public function manage_documents()
    {
        if (!is_admin() && get_option('staff_members_create_inline_customer_groups') == '0') {
            access_denied('Customer Groups');
        }

        if ($this->input->is_ajax_request()) {
            $data = $this->input->post();
            if ($data['id'] == '') {
                $id      = $this->documents_model->add_attachment($data);
                $message = $id ? _l('added_successfully', _l('file')) : '';
                echo json_encode([
                    'success' => $id ? true : false,
                    'message' => $message,
                    'id'      => $id,
                    'name'    => $data['name'],
                ]);
            } else {
                $success = $this->documents_model->edit_attachment($data);
                $message = '';
                if ($success == true) {
                    $message = _l('updated_successfully', _l('file'));
                }
                echo json_encode([
                    'success' => $success,
                    'message' => $message,
                ]);
            }
        }
    }  

}